% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_app_usage.R
\name{extract_app_usage}
\alias{extract_app_usage}
\title{Extract App Usage from Paired Name/Value Columns}
\usage{
extract_app_usage(app_names, app_values)
}
\arguments{
\item{app_names}{Either a character vector (comma-separated strings) or
a list of character vectors, one per row.}

\item{app_values}{Either a character vector (comma-separated strings) or
a list of numeric vectors, one per row. Each block of 6 values corresponds
to one app's usage record.}
}
\value{
A list of tibbles (one per input row). Each tibble contains one or more rows:
\itemize{
\item \code{app}: App name
\item \code{startTimeFar}, \code{endTimeFar}: POSIXct timestamps (UTC)
\item \code{usageFar}: Integer usage during the far window
\item \code{startTimeNear}, \code{endTimeNear}: POSIXct timestamps (UTC)
\item \code{usageNear}: Integer usage during the near window
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Parses app names and usage values into structured usage data, with
start and end timestamps and usage durations for both "Far" and "Near" windows.

The input can be formatted in two ways:
\itemize{
\item If the data is in its raw form (e.g. imported from CSV via \code{\link[=read.csv]{read.csv()}}), both
\code{app_names} and \code{app_values} should be character vectors where
each element is a comma-separated string.
\item If the data was imported via \code{\link[=read_mpath]{read_mpath()}}, then \code{app_names} should
be a list of character vectors, and \code{app_values} should be a list of
integer vectors.
}

The function expects that each app is associated with exactly six values:
\code{startTimeFar}, \code{endTimeFar}, \code{usageFar},
\code{startTimeNear}, \code{endTimeNear}, \code{usageNear}.
}
\section{Time windows}{

Each measurement of app usage includes two time windows: a "near: window that captures recent app
activity (typically ending around the time of the ESM beep), and a "far" window that covers the
24 hours prior to the near window. For both windows, Android automatically provides a start time,
an end time, and the total usage in seconds during that period. These time ranges are determined
by the operating system and may vary across apps and across measurements. Because the start and
end times of these app usage windows rarely align exactly with the time between ESM beeps,
interpreting the values requires caution as the window may include usage that occurred before the
last beep To draw meaningful conclusions about app use between two beeps, it is important to
consider which time windows and how much each window overlaps with that interval. Differences in
the length and timing of these windows can affect your interpretation and should be accounted for
in your analysis.
}

\examples{
# Using character input (e.g., raw from CSV)
app_names <- c("foo", "foo,bar")
app_values <- c(
  "1000,2000,1,3000,4000,2",
  "4000,5000,3,6000,7000,4,8000,9000,5,10000,11000,6"
)
extract_app_usage(app_names, app_values)

# Using list-column input (e.g., from read_mpath())
app_names <- list("foo", c("foo", "bar"))
app_values <- list(
  c(1000,2000,1,3000,4000,2),
  c(4000,5000,3,6000,7000,4,8000,9000,5,10000,11000,6)
)
extract_app_usage(app_names, app_values)

# You can also use this function within a tidyverse pipeline:
library(dplyr)
tibble(app_name = app_names, app_value = app_values) |>
  mutate(usage = extract_app_usage(app_name, app_value))

}
