% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditions.R
\name{mlr_conditions}
\alias{mlr_conditions}
\alias{error_config}
\alias{error_input}
\alias{error_timeout}
\alias{error_mlr3}
\alias{warning_mlr3}
\alias{warning_config}
\alias{warning_input}
\alias{error_learner}
\alias{error_learner_train}
\alias{error_learner_predict}
\title{Error Classes}
\usage{
error_config(msg, ..., class = NULL, signal = TRUE)

error_input(msg, ..., class = NULL, signal = TRUE)

error_timeout(signal = TRUE)

error_mlr3(msg, ..., class = NULL, signal = TRUE)

warning_mlr3(msg, ..., class = NULL, signal = TRUE)

warning_config(msg, ..., class = NULL, signal = TRUE)

warning_input(msg, ..., class = NULL, signal = TRUE)

error_learner(msg, ..., class = NULL, signal = TRUE)

error_learner_train(msg, ..., class = NULL, signal = TRUE)

error_learner_predict(msg, ..., class = NULL, signal = TRUE)
}
\arguments{
\item{msg}{(\code{character(1)})\cr
Error message.}

\item{...}{(any)\cr
Passed to \code{\link[=sprintf]{sprintf()}}.}

\item{class}{(\code{character})\cr
Additional class(es).}

\item{signal}{(\code{logical(1)})\cr
If \code{FALSE}, the condition object is returned instead of being signaled.}
}
\description{
Condition classes for mlr3.
}
\section{Formatting}{

It is also possible to use formatting options as defined in \code{\link[cli:cli_bullets]{cli::cli_bullets}}.
}

\section{Errors}{

\itemize{
\item \code{error_mlr3()} for the base \code{Mlr3Error} class.
\item \code{error_config()} for the \code{Mlr3ErrorConfig} class, which signals that a user has misconfigured
something (e.g. invalid learner configuration).
\item \code{error_input()} for the \code{Mlr3ErrorInput} class, which signals that an invalid input was provided.
\item \code{error_timeout()} for the \code{Mlr3ErrorTimeout}, signalling a timeout (encapsulation).
\item \code{error_learner()} for the \code{Mlr3ErrorLearner}, signalling a learner error.
\item \code{error_learner_train()} for the \code{Mlr3ErrorLearner}, signalling a learner training error.
\item \code{error_learner_predict()} for the \code{Mlr3ErrorLearner}, signalling a learner prediction error.
}
}

\section{Warnings}{

\itemize{
\item \code{warning_mlr3()} for the base \code{Mlr3Warning} class.
\item \code{warning_config()} for the \code{Mlr3WarningConfig} class, which signals that a user might have
misconfigured something.
\item \code{warning_input()} for the \code{Mlr3WarningInput} if an invalid input might have been provided.
}
}

