% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerClassifDebug.R
\name{mlr_learners_classif.debug}
\alias{mlr_learners_classif.debug}
\alias{LearnerClassifDebug}
\title{Classification Learner for Debugging}
\description{
A simple \link{LearnerClassif} used primarily in the unit tests and for debugging purposes.
If no hyperparameter is set, it simply constantly predicts a randomly selected label.
The following hyperparameters trigger the following actions:
\describe{
\item{error_predict:}{Probability to raise an exception during predict.}
\item{error_train:}{Probability to raises an exception during train.}
\item{message_predict:}{Probability to output a message during predict.}
\item{message_train:}{Probability to output a message during train.}
\item{predict_missing:}{Ratio of predictions which will be NA.}
\item{predict_missing_type:}{How to encode missingness. \dQuote{na} will insert NA values, \dQuote{omit} will just return fewer predictions than requested.}
\item{save_tasks:}{Saves input task in \code{model} slot during training and prediction.}
\item{segfault_predict:}{Probability to provokes a segfault during predict.}
\item{segfault_train:}{Probability to provokes a segfault during train.}
\item{sleep_train:}{Function returning a single number determining how many seconds to sleep during \verb{$train()}.}
\item{sleep_predict:}{Function returning a single number determining how many seconds to sleep during \verb{$predict()}.}
\item{threads:}{Number of threads to use. Has no effect.}
\item{warning_predict:}{Probability to signal a warning during predict.}
\item{warning_train:}{Probability to signal a warning during train.}
\item{x:}{Numeric tuning parameter. Has no effect.}
\item{iter:}{Integer parameter for testing hotstarting.}
\item{count_marshaling:}{If \code{TRUE}, \code{marshal_model} will increase the \code{marshal_count} by 1 each time it is called. The default is \code{FALSE}.}
\item{check_pid:}{If \code{TRUE}, the \verb{$predict()} function will throw an error if the model was not unmarshaled in the same session that is used for prediction.)}
}
Note that segfaults may not be triggered reliably on your operating system.
Also note that if they work as intended, they will tear down your R session immediately!
}
\section{Dictionary}{

This \link{Learner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_learners} or with the associated sugar function \code{\link[=lrn]{lrn()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_learners$get("classif.debug")
lrn("classif.debug")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{classif}
\item Predict Types: \dQuote{response}, \dQuote{prob}
\item Feature Types: \dQuote{logical}, \dQuote{integer}, \dQuote{numeric}, \dQuote{character}, \dQuote{factor}, \dQuote{ordered}
\item Required Packages: \CRANpkg{mlr3}
}
}

\section{Parameters}{
\tabular{lllll}{
   Id \tab Type \tab Default \tab Levels \tab Range \cr
   error_predict \tab numeric \tab 0 \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   error_train \tab numeric \tab 0 \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   message_predict \tab numeric \tab 0 \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   message_train \tab numeric \tab 0 \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   predict_missing \tab numeric \tab 0 \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   predict_missing_type \tab character \tab na \tab na, omit \tab - \cr
   save_tasks \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   segfault_predict \tab numeric \tab 0 \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   segfault_train \tab numeric \tab 0 \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   sleep_train \tab untyped \tab - \tab  \tab - \cr
   sleep_predict \tab untyped \tab - \tab  \tab - \cr
   threads \tab integer \tab - \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   warning_predict \tab numeric \tab 0 \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   warning_train \tab numeric \tab 0 \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   x \tab numeric \tab - \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   iter \tab integer \tab 1 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   early_stopping \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   count_marshaling \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   check_pid \tab logical \tab TRUE \tab TRUE, FALSE \tab - \cr
   config_error \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
}
}

\examples{
learner = lrn("classif.debug")
learner$param_set$set_values(message_train = 1, save_tasks = TRUE)

# this should signal a message
task = tsk("penguins")
learner$train(task)
learner$predict(task)

# task_train and task_predict are the input tasks for train() and predict()
names(learner$model)
}
\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/chapters/chapter2/data_and_basic_modeling.html#sec-learners}
\item Package \CRANpkg{mlr3learners} for a solid collection of essential learners.
\item Package \href{https://github.com/mlr-org/mlr3extralearners}{mlr3extralearners} for more learners.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[=Learner]{Learners}: \link{mlr_learners}
\item \code{as.data.table(mlr_learners)} for a table of available \link[=Learner]{Learners} in the running session (depending on the loaded packages).
\item \CRANpkg{mlr3pipelines} to combine learners with pre- and postprocessing steps.
\item Package \CRANpkg{mlr3viz} for some generic visualizations.
\item Extension packages for additional task types:
\itemize{
\item \CRANpkg{mlr3proba} for probabilistic supervised regression and survival analysis.
\item \CRANpkg{mlr3cluster} for unsupervised clustering.
}
\item \CRANpkg{mlr3tuning} for tuning of hyperparameters, \CRANpkg{mlr3tuningspaces}
for established default tuning spaces.
}

Other Learner: 
\code{\link{Learner}},
\code{\link{LearnerClassif}},
\code{\link{LearnerRegr}},
\code{\link{mlr_learners}},
\code{\link{mlr_learners_classif.featureless}},
\code{\link{mlr_learners_classif.rpart}},
\code{\link{mlr_learners_regr.debug}},
\code{\link{mlr_learners_regr.featureless}},
\code{\link{mlr_learners_regr.rpart}}
}
\concept{Learner}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3:LearnerClassif]{mlr3::LearnerClassif}} -> \code{LearnerClassifDebug}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{marshaled}}{(\code{logical(1)})\cr
Whether the learner has been marshaled.}

\item{\code{internal_valid_scores}}{Retrieves the internal validation scores as a named \code{list()}.
Returns \code{NULL} if learner is not trained yet.}

\item{\code{internal_tuned_values}}{Retrieves the internally tuned values as a named \code{list()}.
Returns \code{NULL} if learner is not trained yet.}

\item{\code{validate}}{How to construct the internal validation data. This parameter can be either \code{NULL},
a ratio in $(0, 1)$, \code{"test"}, or \code{"predefined"}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerClassifDebug-new}{\code{LearnerClassifDebug$new()}}
\item \href{#method-LearnerClassifDebug-marshal}{\code{LearnerClassifDebug$marshal()}}
\item \href{#method-LearnerClassifDebug-unmarshal}{\code{LearnerClassifDebug$unmarshal()}}
\item \href{#method-LearnerClassifDebug-importance}{\code{LearnerClassifDebug$importance()}}
\item \href{#method-LearnerClassifDebug-selected_features}{\code{LearnerClassifDebug$selected_features()}}
\item \href{#method-LearnerClassifDebug-clone}{\code{LearnerClassifDebug$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="base_learner"><a href='../../mlr3/html/Learner.html#method-Learner-base_learner'><code>mlr3::Learner$base_learner()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="configure"><a href='../../mlr3/html/Learner.html#method-Learner-configure'><code>mlr3::Learner$configure()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="encapsulate"><a href='../../mlr3/html/Learner.html#method-Learner-encapsulate'><code>mlr3::Learner$encapsulate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format"><a href='../../mlr3/html/Learner.html#method-Learner-format'><code>mlr3::Learner$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help"><a href='../../mlr3/html/Learner.html#method-Learner-help'><code>mlr3::Learner$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict"><a href='../../mlr3/html/Learner.html#method-Learner-predict'><code>mlr3::Learner$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata"><a href='../../mlr3/html/Learner.html#method-Learner-predict_newdata'><code>mlr3::Learner$predict_newdata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print"><a href='../../mlr3/html/Learner.html#method-Learner-print'><code>mlr3::Learner$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset"><a href='../../mlr3/html/Learner.html#method-Learner-reset'><code>mlr3::Learner$reset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train"><a href='../../mlr3/html/Learner.html#method-Learner-train'><code>mlr3::Learner$train()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="LearnerClassif" data-id="predict_newdata_fast"><a href='../../mlr3/html/LearnerClassif.html#method-LearnerClassif-predict_newdata_fast'><code>mlr3::LearnerClassif$predict_newdata_fast()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerClassifDebug-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerClassifDebug-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerClassifDebug$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerClassifDebug-marshal"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerClassifDebug-marshal}{}}}
\subsection{Method \code{marshal()}}{
Marshal the learner's model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerClassifDebug$marshal(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(any)\cr
Additional arguments passed to \code{\link[=marshal_model]{marshal_model()}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerClassifDebug-unmarshal"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerClassifDebug-unmarshal}{}}}
\subsection{Method \code{unmarshal()}}{
Unmarshal the learner's model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerClassifDebug$unmarshal(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(any)\cr
Additional arguments passed to \code{\link[=unmarshal_model]{unmarshal_model()}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerClassifDebug-importance"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerClassifDebug-importance}{}}}
\subsection{Method \code{importance()}}{
Returns 0 for each feature seen in training.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerClassifDebug$importance()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Named \code{numeric()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerClassifDebug-selected_features"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerClassifDebug-selected_features}{}}}
\subsection{Method \code{selected_features()}}{
Always returns character(0).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerClassifDebug$selected_features()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{character()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerClassifDebug-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerClassifDebug-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerClassifDebug$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
