% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warn_deprecated.R
\name{deprecated_binding_old}
\alias{deprecated_binding_old}
\title{Create an Active Binding that Generates a Deprecation Warning}
\usage{
deprecated_binding_old(what, value)
}
\arguments{
\item{what}{(character(1))\cr
A description of the deprecated binding. Should be of the form \code{"Class$field"}.}

\item{value}{(any)\cr
The value of the active binding. This should be an expression that will
be evaluated in the context of the active binding. It could, for example,
refer to \code{self}.}
}
\description{
Creates an active binding that generates a warning when accessed, using
\code{warn_deprecated_old()}. The active binding will otherwise be read-only.
}
\examples{
MyClass = R6::R6Class("MyClass", public = list(),
  active = list(
    foo = deprecated_binding_old("MyClass$foo", "bar")
  )
)
mco = MyClass$new()
mco$foo
}
\keyword{internal}
