% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.R
\name{mp_power}
\alias{mp_power}
\title{Simulation-based power estimation (engine-agnostic core)}
\usage{
mp_power(
  scenario,
  nsim,
  alpha = 0.05,
  seed = NULL,
  failure_policy = c("count_as_nondetect", "exclude"),
  keep = c("minimal", "fits", "data"),
  conf_level = 0.95
)
}
\arguments{
\item{scenario}{An \code{mp_scenario}.}

\item{nsim}{Positive integer number of simulations.}

\item{alpha}{Significance threshold for a detection (default 0.05).}

\item{seed}{Optional seed for reproducibility.}

\item{failure_policy}{How to treat failed fits / missing p-values:
\itemize{
\item \code{"count_as_nondetect"} (default): failures count as non-detections.
\item \code{"exclude"}: drop failures from the denominator (always reported).
}}

\item{keep}{What to store:
\itemize{
\item \code{"minimal"}: only per-sim summary rows.
\item \code{"fits"}: also store fit objects (may be large).
\item \code{"data"}: also store simulated data (can be very large).
}}

\item{conf_level}{Confidence level for the Wald interval (default 0.95).}
}
\value{
An object of class \code{mp_power}.
}
\description{
\code{mp_power()} runs repeated simulations under a scenario and estimates power for
the scenario's test decision rule (typically p < alpha).
}
\details{
In Phase 4 core, the scenario must provide engine functions:
\code{simulate_fun}, \code{fit_fun}, and \code{test_fun}. Later phases will supply defaults
based on specific backends (e.g., lme4).
}
\examples{
# A tiny toy engine (not mixed models) just to demonstrate the workflow:
d <- mp_design(list(subject = 30), trials_per_cell = 1)
a <- mp_assumptions(list(condition = 0.3), residual_sd = 1)

sim_fun <- function(scn, seed) {
  n <- scn$design$clusters$subject
  x <- stats::rbinom(n, 1, 0.5)
  y <- scn$assumptions$fixed_effects$condition * x +
    stats::rnorm(n, sd = scn$assumptions$residual_sd)
  data.frame(y = y, condition = x)
}
fit_fun <- function(dat, scn) stats::lm(scn$formula, data = dat)
test_fun <- function(fit, scn) {
  sm <- summary(fit)
  p <- sm$coefficients["condition", "Pr(>|t|)"]
  list(p_value = as.numeric(p))
}

s <- mp_scenario(
  y ~ condition, d, a,
  simulate_fun = sim_fun,
  fit_fun = fit_fun,
  test_fun = test_fun
)
res <- mp_power(s, nsim = 50, seed = 1)
summary(res)
}
