% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals-utils.R
\name{gintervals.covered_bp}
\alias{gintervals.covered_bp}
\title{Calculate total base pairs covered by intervals}
\usage{
gintervals.covered_bp(intervals = NULL)
}
\arguments{
\item{intervals}{set of one-dimensional intervals}
}
\value{
A single numeric value representing the total number of base pairs
covered by the intervals.
}
\description{
Returns the total number of base pairs covered by a set of intervals.
}
\details{
This function first canonicalizes the intervals to remove overlaps and
touching intervals, then sums up the lengths of all resulting intervals.
Overlapping intervals are counted only once.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()

# Create some intervals
intervs <- gintervals(
    c("chr1", "chr1", "chr2"),
    c(100, 150, 1000),
    c(200, 250, 2000)
)

# Calculate total bp covered
# Note: intervals [100,200) and [150,250) overlap,
# so total is (200-100) + (250-150) + (2000-1000) = 100 + 100 + 1000 = 1200
# But after canonicalization: [100,250) + [1000,2000) = 150 + 1000 = 1150
gintervals.covered_bp(intervs)

}
\seealso{
\code{\link{gintervals}}, \code{\link{gintervals.canonic}},
\code{\link{gintervals.coverage_fraction}}
}
\keyword{~coverage}
\keyword{~genomics}
