% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{everywhere}
\alias{everywhere}
\title{Evaluate Everywhere}
\usage{
everywhere(.expr, ..., .args = list(), .min = 1L, .compute = NULL)
}
\arguments{
\item{.expr}{(expression) code to evaluate asynchronously, or a language
object. Wrap multi-line expressions in \code{{}}.}

\item{...}{(named arguments | environment) objects required by \code{.expr},
assigned to the daemon's global environment. See 'evaluation' section
below.}

\item{.args}{(named list | environment) objects required by .expr, kept local
to the evaluation environment (unlike \code{...}). See 'evaluation' section
below.}

\item{.min}{(integer) minimum daemons to evaluate on (dispatcher only).
Creates a synchronization point, useful for remote daemons that take time
to connect.}

\item{.compute}{(character) name of the compute profile. Each profile has its
own independent set of daemons. \code{NULL} (default) uses the 'default'
profile.}
}
\value{
A 'mirai_map' (list of 'mirai' objects).
}
\description{
Evaluate an expression 'everywhere' on all connected daemons for the
specified compute profile. Daemons must be set prior to calling this
function. Performs operations across daemons such as loading packages or
exporting common data. Resultant changes to the global environment, loaded
packages and options are persisted regardless of a daemon's \code{cleanup}
setting.
}
\details{
If using dispatcher, this function forces a synchronization point: the
\code{\link[=everywhere]{everywhere()}} call must complete on all daemons before subsequent mirai
evaluations proceed.

Calling \code{\link[=everywhere]{everywhere()}} does not affect the RNG stream for mirai calls when
using a reproducible \code{seed} value at \code{\link[=daemons]{daemons()}}. This allows the seed
associated with each mirai call to be the same, regardless of the number of
daemons used. However, code evaluated in an \code{\link[=everywhere]{everywhere()}} call is itself
non-reproducible if it involves random numbers.
}
\section{Evaluation}{


The expression \code{.expr} will be evaluated in a separate R process in a clean
environment (not the global environment), consisting only of the objects
supplied to \code{.args}, with the objects passed as \code{...} assigned to the global
environment of that process.

As evaluation occurs in a clean environment, all undefined objects must be
supplied through \code{...} and/or \code{.args}, including self-defined functions.
Functions from a package should use namespaced calls such as
\code{mirai::mirai()}, or else the package should be loaded beforehand as part of
\code{.expr}.

Supply objects to \code{...} rather than \code{.args} for evaluation to occur \emph{as if}
in your global environment. This is needed for non-local variables or helper
functions required by other functions, which scoping rules may otherwise
prevent from being found.
}

\examples{
daemons(sync = TRUE)

# export common data by a super-assignment expression:
everywhere(y <<- 3)
mirai(y)[]

# '...' variables are assigned to the global environment
# '.expr' may be specified as an empty {} in such cases:
everywhere({}, a = 1, b = 2)
mirai(a + b - y == 0L)[]

# everywhere() returns a mirai_map object:
mp <- everywhere("just a normal operation")
mp
mp[.flat]
mp <- everywhere(stop("everywhere"))
collect_mirai(mp)
daemons(0)

# loading a package on all daemons
daemons(sync = TRUE)
everywhere(library(parallel))
m <- mirai("package:parallel" \%in\% search())
m[]
daemons(0)

}
