% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extgp.R
\name{tstab.egp}
\alias{tstab.egp}
\title{Threshold stability plots for extended generalized Pareto models}
\usage{
tstab.egp(
  xdat,
  thresh,
  model = c("pt-beta", "pt-gamma", "pt-power", "gj-tnorm", "gj-beta", "exptilt",
    "logist"),
  param = c("shape", "kappa"),
  type = c("wald", "lrt"),
  transform = FALSE,
  level = 0.95,
  plot = TRUE,
  ...
)
}
\arguments{
\item{xdat}{vector of observations, greater than the threshold}

\item{thresh}{threshold value}

\item{model}{a string indicating which extended family to fit}

\item{param}{[string] parameter, either \code{shape} or additional parameter \code{kappa}}

\item{type}{[string] confidence interval type, either \code{wald} or \code{profile}.}

\item{transform}{logical; if \code{TRUE} and \code{type="wald"}, intervals for \code{kappa} are computed on the log-scale and back-transformed.}

\item{level}{[double] confidence interval level, default to 0.95.}

\item{plot}{[logical] if \code{TRUE} (default), return a threshold stability plot}

\item{...}{additional arguments for the plot function, currently ignored.}
}
\value{
an invisible list object of class \code{mev_egp_tstab} with elements
\itemize{
\item{\code{kappa}:}  matrix of parameter estimates and confidence intervals for \eqn{\kappa}, if specified in \code{param}
\item{\code{shape}:}  matrix of parameter estimates and confidence intervals for the shape parameter \eqn{\xi}, if specified in \code{param}
\item{\code{thresh}:} vector of threshold candidates
\item{\code{level}:} level of the confidence intervals
\item{\code{model}:} string giving the EGP model family
\item{\code{type}:} type of confidence interval
}
}
\description{
Threshold stability plots for extended generalized Pareto models
}
\examples{
xdat <- rgp(n = 1000)
tstab.egp(
 xdat = xdat,
 thresh = c(0, quantile(xdat, 0.5)),
 model = "gj-tnorm",
 param = "kappa",
 transform = TRUE)

}
