% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phreg.R
\name{logitSurv}
\alias{logitSurv}
\title{Proportional odds survival model}
\usage{
logitSurv(formula, data, offset = NULL, weights = NULL, ...)
}
\arguments{
\item{formula}{formula with 'Surv' outcome (see \code{coxph})}

\item{data}{data frame}

\item{offset}{offsets for exp(x beta) terms}

\item{weights}{weights for score equations}

\item{...}{Additional arguments to lower level funtions}
}
\description{
Semiparametric Proportional odds model, that has the advantage that 
\deqn{
logit(S(t|x)) = \log(\Lambda(t)) + x \beta
}
so covariate effects give OR of survival.
}
\details{
This is equivalent to using a hazards model 
\deqn{
  Z \lambda(t) \exp(x \beta)
}
where Z is gamma distributed with mean and variance 1.
}
\examples{
library(mets)
data(TRACE)
dcut(TRACE) <- ~.
out1 <- logitSurv(Surv(time,status==9)~vf+chf+strata(wmicat.4),data=TRACE)
summary(out1)
gof(out1)
plot(out1)
}
\references{
The proportional odds cumulative incidence model for competing risks,
Eriksson, Frank and Li, Jianing and Scheike, Thomas and Zhang, Mei-Jie,
Biometrics, 2015, 3, 687--695, 71,
}
\author{
Thomas Scheike
}
