## -----------------------------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = TRUE
)

vcr::setup_knitr(prefix = "meetupr-")
meetupr:::mock_if_no_auth()
meetupr::local_meetupr_debug(0)

## -----------------------------------------------------------------------------
library(meetupr)

## -----------------------------------------------------------------------------
meetupr_sitrep()

## -----------------------------------------------------------------------------
meetupr_sitrep()

## -----------------------------------------------------------------------------
group_info <- get_group("rladies-lagos")
str(group_info)

## -----------------------------------------------------------------------------
events <- get_group_events("rladies-lagos")
head(events)

## -----------------------------------------------------------------------------
past_events <- get_group_events(
  "rladies-lagos",
  status = "past",
  max_results = 10
)
head(past_events)

## -----------------------------------------------------------------------------
# Events from 2024 onwards
recent_events <- get_group_events(
  "rladies-lagos",
  status = "past",
  date_after = "2024-01-01T00:00:00Z"
)
head(recent_events)

## -----------------------------------------------------------------------------
event <- get_event(id = "103349942")
event

## -----------------------------------------------------------------------------
rsvps <- get_event_rsvps(id = "103349942")
head(rsvps)

## -----------------------------------------------------------------------------
members <- get_group_members("rladies-lagos", max_results = 10)
head(members)

## -----------------------------------------------------------------------------
r_groups <- find_groups("R programming")
head(r_groups)

## -----------------------------------------------------------------------------
# Get up to 50 events (may require multiple API calls)
many_events <- get_group_events(
  "rladies-san-francisco",
  status = "past",
  max_results = 50
)

cli::cli_alert_info("Retrieved {nrow(many_events)} events")

## -----------------------------------------------------------------------------
# # Get all groups in the R-Ladies network
# pro_groups <- get_pro_groups("rladies")
# head(pro_groups)

## -----------------------------------------------------------------------------
# # Get upcoming events across all groups in network
# upcoming <- get_pro_events("rladies", status = "upcoming")
# head(upcoming)
# 
# # Get cancelled events
# cancelled <- get_pro_events("rladies", status = "cancelled")
# head(cancelled)

## -----------------------------------------------------------------------------
local_meetupr_debug(1)
meetupr_sitrep()
find_groups("R programming")

## -----------------------------------------------------------------------------
local_meetupr_debug(0)
meetupr_sitrep()
find_groups("R programming")

