% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_ma.R
\name{mc_ma}
\alias{mc_ma}
\title{Moving Average Model Structure}
\source{
Bonat, W. H. (2018). Multiple Response Variables Regression
Models in R: The mcglm Package. Journal of Statistical Software, 84(4):1--30.
}
\usage{
mc_ma(id, time, data, order = 1)
}
\arguments{
\item{id}{name of the column (string) containing the subject index.
Note that this structure was designed to deal with longitudinal data.
For times series data use the same \code{id} for all observations
(one unit sample).}

\item{time}{name of the column (string) containing the index indicating
the time.}

\item{data}{data set.}

\item{order}{An integer specifying the order of the moving average process.}
}
\value{
A list with the following component:
\describe{
  \item{Z1}{A sparse matrix of class \code{nsCMatrix} representing the
  moving average component of the matrix linear predictor. The matrix
  has dimension equal to the total number of observations and is
  constructed as a block-diagonal matrix, with one block per subject
  (or time series), each block encoding a moving average structure of
  the specified order.}
}
}
\description{
Builds components of the matrix linear predictor associated
  with moving average (MA) covariance structures. This function is mainly
  intended for longitudinal data analysis, but can also be used for
  time series data
}
\details{
This function was primarily designed for longitudinal data,
  but it can also be used for time series analysis. In this case, the
  \code{id} argument should contain a single identifier, representing
  one observational unit. Internally, the function constructs block-diagonal
  band matrices using \code{\link[Matrix]{bandSparse}}.
}
\examples{
id <- rep(1:2, each = 4)
time <- rep(1:4, 2)
data <- data.frame("id" = id, "time" = time)
mc_ma(id = "id", time = "time", data = data, order = 1)
mc_ma(id = "id", time = "time", data = data, order = 2)

}
\seealso{
\code{mc_id}, \code{mc_dist}, \code{mc_car},
\code{mc_rw} and \code{mc_mixed}.
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
