% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussian-elimination.R
\name{Ginv}
\alias{Ginv}
\title{Generalized Inverse of a Matrix}
\usage{
Ginv(A, tol = sqrt(.Machine$double.eps), verbose = FALSE, fractions = FALSE)
}
\arguments{
\item{A}{numerical matrix}

\item{tol}{tolerance for checking for 0 pivot}

\item{verbose}{logical; if \code{TRUE}, print intermediate steps}

\item{fractions}{logical; if \code{TRUE}, try to express non-integers as rational numbers, using the \code{\link[MASS]{fractions}}
function; if you require greater accuracy, you can set the \code{cycles} (default 10)
and/or \code{max.denominator} (default 2000) arguments to \code{fractions} as a global option, e.g.,
\code{options(fractions=list(cycles=100, max.denominator=10^4))}.}
}
\value{
the generalized inverse of \code{A}, expressed as fractions if \code{fractions=TRUE}, or rounded
}
\description{
\code{Ginv} returns an arbitrary generalized inverse of the matrix \code{A}, using \code{gaussianElimination}.
}
\details{
A generalized inverse is a matrix \eqn{\mathbf{A}^-} satisfying \eqn{\mathbf{A A^- A} = \mathbf{A}}.

The purpose of this function is mainly to show how the generalized inverse can be computed using
Gaussian elimination.
}
\examples{
A <- matrix(c(1,2,3,4,5,6,7,8,10), 3, 3) # a nonsingular matrix
A
Ginv(A, fractions=TRUE)  # a generalized inverse of A = inverse of A
round(Ginv(A) \%*\% A, 6)  # check

B <- matrix(1:9, 3, 3) # a singular matrix
B
Ginv(B, fractions=TRUE)  # a generalized inverse of B
B \%*\% Ginv(B) \%*\% B   # check

}
\seealso{
\code{\link[MASS]{ginv}} for a more generally usable function
}
\author{
John Fox
}
