% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/closed_figures.R
\name{triangle}
\alias{triangle}
\title{Coordinates of a triangle}
\usage{
triangle(
  size.x = 10,
  size.y = size.x,
  pos.x = 0,
  pos.y = 0,
  rot = pi/2,
  shd = NA,
  vis = 1,
  lty = 1,
  lwd = 3
)
}
\arguments{
\item{size.x}{numeric, define the semi-major axis of the ellipse within which the figure is inscribed. Default is 10}

\item{size.y}{numeric, define the semi-minor axis of the ellipse within which the figure is inscribed. Default is size.x}

\item{pos.x}{numeric, position on the x axis. Default is 0}

\item{pos.y}{numeric, position the y axis, Default is 0}

\item{rot}{define the rotation. Default is \eqn{\frac{\pi}{2}}}

\item{shd}{character, define the shading of the figure. Default is NA which results in a transparent figure}

\item{vis}{Visibility of the figure. Default is 1, making the figure visible. To hide the figure, change it to 0}

\item{lty}{integer, define the line type of the figure, default is 1 (solid line).}

\item{lwd}{integer, define the line width of the figure. Default is 3}
}
\value{
Return the coordinates for drawing a triangle
}
\description{
Define the coordinates for drawing a triangle
}
\examples{
# return the default coordinates for drawing a triangle
triangle()
# change the coordinates for drawing a smaller triangle
triangle(size.x = 5)
}
