% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lfmcorrinhom.R
\name{lfmcorrinhom}
\alias{lfmcorrinhom}
\title{Local mark correlation functions for inhomogeneous point patterns with function-valued marks.}
\usage{
lfmcorrinhom(X,
ftype = c("variogram", "stoyan", "rcorr", "shimatani", "beisbart",
 "isham", "stoyancov", "schlather"),
r = NULL,
lambda = NULL,
method_lambda = c("kernel", "Voronoi"),
bw = NULL,
f = NULL,
method = c("density", "loess"),
correction = c("Ripley", "translate", "none"),
normalise = TRUE,
tol = 0.01,
...)
}
\arguments{
\item{X}{An object of class ppp or lpp.}

\item{ftype}{Type of the test function \eqn{t_f}. Currently any selection of \code{"variogram", "stoyan", "rcorr", "shimatani", "beisbart", "isham", "stoyancov", "schlather"}.}

\item{r}{Optional. The values of the argument \code{r} at which the mark correlation function should be evaluated.}

\item{lambda}{Estimated intensity at data points. If not given, it will be estimated internally. See details.}

\item{method_lambda}{The method to be used for estimating intensity at data points, if \code{lambda = NULL}.}

\item{bw}{Bandwidth method to be used for estimating intensity at data points if \code{lambda = NULL} and \code{method_lambda = "kernel"}.}

\item{f}{Optional. Test function \eqn{t_f} used in the definition of the mark correlation function. If \code{ftype} is given, \eqn{t_f} should be \code{NULL}.}

\item{method}{Type of smoothing, either \code{density} or \code{loess}.}

\item{correction}{Type of edge correction to be applied, either of \code{"Ripley", "translate", "none"}. This is used only if \code{X} is of class ppp.}

\item{normalise}{If \code{normalise=FALSE}, only the numerator of the expression for the mark correlation function will be computed.}

\item{tol}{Tolerance used in the calculation of the conditional mean of marks. This is used only if \code{ftype} is \code{schlather}.}

\item{...}{Arguments passed to \code{\link[spatstat.univar]{unnormdensity}} or \code{\link[stats]{loess}}.}
}
\value{
a data.frame which gives the estimated overall local mark correlation function and the distance vector \eqn{r} at which the local mark correlation function is estimated. The outputs of the local mark correlation functions for each time point are stored as an attribute, which can be extracted as \code{attr(., "ests.time")}.
The outputs of the local mark correlation functions for each data point are stored as an attribute, which can be extracted as \code{attr(., "ests.points")}.
}
\description{
Local mark correlation functions for inhomogeneous point patterns with function-valued marks.
}
\details{
This function computes local mark correlation functions for an inhomogeneous point pattern with a function-valued mark. See the details of test functions used in \code{\link[markstat]{fmcorrinhom}}. Technical details are given in Eckardt and Moradi (2025).
}
\examples{
 library(spatstat.random)
 library(spatstat.geom)
 library(spatstat.explore)
 X <- rpoispp(100)
 marks(X) <- data.frame(
 t1 = runif(npoints(X),1,10),
 t2 = runif(npoints(X),1,10),
 t3 = runif(npoints(X),1,10),
 t4 = runif(npoints(X),1,10),
 t5 = runif(npoints(X),1,10))
 lfmcorrinhom(X, ftype = "stoyan", method = "density", method_lambda = "kernel", bw = bw.scott)
 
 
}
\references{
Eckardt, M., Mateu, J., & Moradi, M. (2024). Function‐Valued Marked Spatial Point Processes on Linear Networks: Application to Urban Cycling Profiles. Stat, 13(4), e70013.

Eckardt, M., & Moradi, M. (2025). Local indicators of mark association for marked spatial point processes.

Moradi, M., & Eckardt, M. (2025). Inhomogeneous mark correlation functions for general marked point processes. arXiv e-prints, arXiv-2505.
}
\seealso{
\code{\link[markstat]{fmcorr}}, \code{\link[markstat]{mcorrinhom.ppp}}, \code{\link[markstat]{mcorrinhom.lpp}}.
}
\author{
Mehdi Moradi \email{m2.moradi@yahoo.com} and Matthias Eckardt
}
