#' mpa: Marine Predators Algorithm
#'
#' @description
#' Implementation of the Marine Predators Algorithm (MPA) in R. MPA is a
#' nature-inspired metaheuristic optimization algorithm that follows the rules
#' governing optimal foraging strategy and encounter rate policy between
#' predator and prey in marine ecosystems.
#'
#' @details
#' The Marine Predators Algorithm is based on the foraging behavior of marine
#' predators and their interactions with prey. The algorithm operates in three
#' phases that balance exploration and exploitation:
#'
#' \enumerate{
#'   \item \strong{Phase 1} (High velocity ratio): Prey moves faster than predator.
#'     Exploration is emphasized using Brownian motion.
#'   \item \strong{Phase 2} (Unit velocity ratio): Predator and prey move at similar
#'     speeds. Mixed strategy with both Brownian motion and Levy flight.
#'   \item \strong{Phase 3} (Low velocity ratio): Predator moves faster than prey.
#'     Exploitation is emphasized using Levy flight.
#' }
#'
#' @section Main Functions:
#' \describe{
#'   \item{[mpa()]}{Main optimization function implementing the MPA algorithm}
#'   \item{[get_function_details()]}{Retrieve benchmark function parameters}
#' }
#'
#' @section Helper Functions:
#' \describe{
#'   \item{[levy()]}{Generate Levy flight random steps}
#'   \item{[initialize_population()]}{Initialize search agent population}
#' }
#'
#' @section Benchmark Functions:
#' The package includes 23 standard benchmark functions (F1-F23) for testing
#' optimization algorithms. See \code{\link{test-functions}} for a complete list.
#'
#' @section Getting Started:
#' \preformatted{
#' library(marinepredator)
#'
#' # Basic optimization with the Sphere function
#' result <- mpa(
#'   SearchAgents_no = 30,
#'   Max_iter = 100,
#'   lb = -100, ub = 100,
#'   dim = 30,
#'   fobj = F01
#' )
#' print(result)
#' }
#'
#' @references
#' Faramarzi, A., Heidarinejad, M., Mirjalili, S., & Gandomi, A. H. (2020).
#' Marine Predators Algorithm: A Nature-inspired Metaheuristic.
#' Expert Systems with Applications, 152, 113377.
#' \doi{10.1016/j.eswa.2020.113377}
#'
#' @seealso
#' Useful links:
#' \itemize{
#'   \item GitHub repository: \url{https://github.com/urbs-dev/marinepredator}
#'   \item Report bugs: \url{https://github.com/urbs-dev/marinepredator/issues}
#' }
#'
#' @keywords internal
"_PACKAGE"

## usethis namespace: start
#' @importFrom dplyr %>%
## usethis namespace: end
NULL
