% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_ison.R
\docType{data}
\name{ison_hightech}
\alias{ison_hightech}
\title{One-mode multiplex, directed network of managers of a high-tech company (Krackhardt 1987)}
\format{
\if{html}{\out{<div class="sourceCode">}}\preformatted{#> -- # High-tech company managers ------------------------------------------------
#> # A multiplex, directed network of 21 managers and 190 advice, 102 friends, and
#> 20 reports ties
#> 
#> -- Nodes
#> # A tibble: 21 x 4
#>     age tenure level dept 
#>   <dbl>  <dbl> <dbl> <chr>
#> 1    33      9     1 E    
#> 2    42     20     2 E    
#> 3    40     13     1 C    
#> 4    33      8     1 E    
#> 5    32      3     1 C    
#> 6    59     28     1 B    
#> # i 15 more rows
#> 
#> -- Ties
#> # A tibble: 312 x 3
#>    from    to type   
#>   <int> <int> <chr>  
#> 1     1     2 friends
#> 2     1     2 advice 
#> 3     1     2 reports
#> 4     1     4 friends
#> 5     1     4 advice 
#> 6     1     8 friends
#> # i 306 more rows
#> 
}\if{html}{\out{</div>}}
}
\usage{
data(ison_hightech)
}
\description{
21 managers of a company of just over 100 employees manufactured high-tech equipment
on the west coast of the United States.
Three types of ties were collected:
\itemize{
\item \emph{friends}: managers' answers to the question "Who is your friend?"
\item \emph{advice}: managers' answers to the question "To whom do you go to for advice?"
\item \emph{reports}: "To whom do you report?" based on company reports
}

The data is anonymised, but four nodal attributes are included:
\itemize{
\item \emph{age}: the manager's age in years
\item \emph{tenure}: the manager's length of service
\item \emph{level}: the manager's level in the corporate hierarchy,
where 3 = CEO, 2 = Vice President, and 1 = manager
\item \emph{dept}: one of four departments, B, C, D, E,
with the CEO alone in A
}
}
\references{
Krackhardt, David. 1987. "Cognitive social structures". \emph{Social Networks} 9: 104-134.
}
\keyword{datasets}
