% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grok_processor.R
\name{GrokProcessor}
\alias{GrokProcessor}
\title{Grok API Processor}
\description{
Grok API Processor

Grok API Processor
}
\details{
Concrete implementation of BaseAPIProcessor for Grok models.
Handles Grok-specific API calls, authentication, and response parsing.
}
\section{Super class}{
\code{\link[mLLMCelltype:BaseAPIProcessor]{mLLMCelltype::BaseAPIProcessor}} -> \code{GrokProcessor}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GrokProcessor-new}{\code{GrokProcessor$new()}}
\item \href{#method-GrokProcessor-get_default_api_url}{\code{GrokProcessor$get_default_api_url()}}
\item \href{#method-GrokProcessor-make_api_call}{\code{GrokProcessor$make_api_call()}}
\item \href{#method-GrokProcessor-extract_response_content}{\code{GrokProcessor$extract_response_content()}}
\item \href{#method-GrokProcessor-clone}{\code{GrokProcessor$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mLLMCelltype" data-topic="BaseAPIProcessor" data-id="get_api_url"><a href='../../mLLMCelltype/html/BaseAPIProcessor.html#method-BaseAPIProcessor-get_api_url'><code>mLLMCelltype::BaseAPIProcessor$get_api_url()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mLLMCelltype" data-topic="BaseAPIProcessor" data-id="process_request"><a href='../../mLLMCelltype/html/BaseAPIProcessor.html#method-BaseAPIProcessor-process_request'><code>mLLMCelltype::BaseAPIProcessor$process_request()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GrokProcessor-new"></a>}}
\if{latex}{\out{\hypertarget{method-GrokProcessor-new}{}}}
\subsection{Method \code{new()}}{
Initialize Grok processor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GrokProcessor$new(base_url = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GrokProcessor-get_default_api_url"></a>}}
\if{latex}{\out{\hypertarget{method-GrokProcessor-get_default_api_url}{}}}
\subsection{Method \code{get_default_api_url()}}{
Get default Grok API URL
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GrokProcessor$get_default_api_url()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GrokProcessor-make_api_call"></a>}}
\if{latex}{\out{\hypertarget{method-GrokProcessor-make_api_call}{}}}
\subsection{Method \code{make_api_call()}}{
Make API call to Grok
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GrokProcessor$make_api_call(chunk_content, model, api_key)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GrokProcessor-extract_response_content"></a>}}
\if{latex}{\out{\hypertarget{method-GrokProcessor-extract_response_content}{}}}
\subsection{Method \code{extract_response_content()}}{
Extract response content from Grok API response
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GrokProcessor$extract_response_content(response, model)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GrokProcessor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GrokProcessor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GrokProcessor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
