% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gapremove.R
\name{gapremove}
\alias{gapremove}
\title{Removing gap-rich positions and/or reads/sequences}
\usage{
gapremove(fasta, vgappct = 70, hgappct = 70, fastaname = "filteredfast.fasta")
}
\arguments{
\item{fasta}{Input as a read or multiple sequence alignment in FASTA format}

\item{vgappct}{The percent cut-off of vertical gap (-), i.e., if a position in the alignment has \%gap >= vgappct, that position will be removed.}

\item{hgappct}{The percent cut-off of horizontal gap (-), i.e., if a sequence or read in the alignment has \%gap >= hgappct, that sequence or read will be removed.}

\item{fastaname}{Output file name in FASTA format}
}
\value{
FASTA read or multiple sequence alignment written out to the input directory
}
\description{
Removes nucleotide positions (vertical) and/or reads/sequences (horizontal) that contain gaps more than the specified cut-off percentage from the alignment.
}
\examples{
## Locate input FASTA file-------------------------------------------------------------------------
fastafilepath <- system.file("extdata", "gaprichfast.fasta", package = "longreadvqs")

## Indicate output directory and file name---------------------------------------------------------
outfast <- tempfile()

## Remove positions with gap >= 60\% and reads/sequences with gap >= 10\%----------------------------
gapremove(fastafilepath, vgappct = 60, hgappct = 10, fastaname = outfast)

}
