test_that("ttable returns correct contingency table", {
    from <- c("A", "A", "B", "C")
    to <- c("B", "B", "C", "C")
    expect_equal(dim(ttable(from, to)), c(3, 3))
    expect_error(ttable(from = c("A", "A"), to = c("A", "A")), "There must be at least two group levels in the data")
    expect_error(ttable(from = c(1, 1), to = c(1, 1)), "There must be at least two group levels in the data")
    expect_silent(ttable(from = c(1, 2), to = c(1, 1)))
    from <- c("A", "A", "NA", "C", "C", "C")
    to <- c("A", "B", "B", "C", "C", "C")
    result <- ttable(from, to)
    expect_true(all(c("NA", "A", "B", "C") %in% rownames(result)))
    expect_true(all(c("NA", "A", "B", "C") %in% colnames(result)))
})