% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdalControls.R
\name{searchGDALX}
\alias{searchGDALX}
\title{Search recursively for valid GDAL installation(s) on Linux/macOS}
\usage{
searchGDALX(MP = "default", quiet = TRUE)
}
\arguments{
\item{MP}{Character. Search root. `"default"` expands to `c("~","/opt","/usr/local","/usr")`.
You may also pass a single directory (e.g. `"/usr"`).}

\item{quiet}{Logical. If `TRUE`, suppress messages.}
}
\value{
A list with:
\describe{
  \item{gdalInstallations}{data.frame with columns `binDir`, `baseDir`, `installation_type`.}
  \item{bin}{list of data.frames (column `gdal_bin`) with detected GDAL binaries per installation.}
  \item{py}{list of data.frames (column `gdal_py`) with detected GDAL python tools per installation.}
}
}
\description{
Searches for an executable `gdalinfo` and returns a normalized installations
table plus best-effort lists of GDAL binaries (`gdal*`) and python tools (`*.py`)
found alongside the detected `gdalinfo`.
}
\details{
This implementation is portable: it does NOT use GNU-only `find` primaries
such as `-readable`, and it uses `system2(..., args=...)` with proper token
separation (no shell parsing assumptions).
}
\examples{
\dontrun{
x <- searchGDALX()
x$gdalInstallations
}
}
\keyword{internal}
