% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecate.R
\name{deprecate_soft}
\alias{deprecate_soft}
\alias{deprecate_warn}
\alias{deprecate_stop}
\title{Deprecate functions and arguments}
\usage{
deprecate_soft(
  when,
  what,
  with = NULL,
  details = NULL,
  id = NULL,
  env = caller_env(),
  user_env = caller_env(2)
)

deprecate_warn(
  when,
  what,
  with = NULL,
  details = NULL,
  id = NULL,
  always = FALSE,
  env = caller_env(),
  user_env = caller_env(2)
)

deprecate_stop(when, what, with = NULL, details = NULL, env = caller_env())
}
\arguments{
\item{when}{A string giving the version when the behaviour was deprecated.}

\item{what}{A string describing what is deprecated:
\itemize{
\item Deprecate a whole function with \code{"foo()"}.
\item Deprecate an argument with \code{"foo(arg)"}.
\item Partially deprecate an argument with
\code{"foo(arg = 'must be a scalar integer')"}.
\item Deprecate anything else with a custom message by wrapping it in \code{I()}.
}

You can optionally supply the namespace: \code{"ns::foo()"}, but this is
usually not needed as it will be inferred from the caller environment.}

\item{with}{An optional string giving a recommended replacement for the
deprecated behaviour. This takes the same form as \code{what}.}

\item{details}{In most cases the deprecation message can be
automatically generated from \code{with}. When it can't, use \code{details}
to provide a hand-written message.

\code{details} can either be a single string or a character vector,
which will be converted to a \link[cli:cli_bullets]{bulleted list}.
By default, info bullets are used. Provide a named vectors to
override.}

\item{id}{The id of the deprecation. A warning is issued only once for each
\code{id}. Defaults to the generated message, but you should provide a unique
\code{id} when the message in \code{details} is built programmatically and depends on
inputs, or when you'd like to deprecate multiple functions but warn only
once for all of them. Repeated calls to \code{deprecate_soft()} and
\code{deprecate_warn()} are also much faster if you supply an \code{id} because it
avoids spending time generating the message only to immediately exit if the
once per session warning has already been thrown before.}

\item{env, user_env}{Pair of environments that define where \verb{deprecate_*()}
was called (used to determine the package name) and where the function
called the deprecating function was called (used to determine if
\code{deprecate_soft()} should message).

These are only needed if you're calling \verb{deprecate_*()} from an internal
helper, in which case you should forward \code{env = caller_env()} and
\code{user_env = caller_env(2)}.}

\item{always}{If \code{FALSE}, the default, will warn once per session. If
\code{TRUE}, will always warn in direct usages. Indirect usages keep
warning once per session to avoid disrupting users who can't fix the
issue. Only use \code{always = TRUE} after at least one release with
the default.}
}
\value{
\code{NULL}, invisibly.
}
\description{
These functions provide three levels of verbosity for deprecated
functions. Learn how to use them in \code{vignette("communicate")}.
\itemize{
\item \code{deprecate_soft()} warns only if the deprecated function is called
directly, i.e. a user is calling a function they wrote in the global
environment or a developer is calling it in their package. It does not
warn when called indirectly, i.e. the deprecation comes from code that
you don't control.
\item \code{deprecate_warn()} warns unconditionally.
\item \code{deprecate_stop()} fails unconditionally.
}

Warnings are only issued once per session to avoid overwhelming
the user. Control with \code{\link[=verbosity]{options(lifecycle_verbosity)}}.
}
\section{Conditions}{

\itemize{
\item Deprecation warnings have class \code{lifecycle_warning_deprecated}.
\item Deprecation errors have class \code{lifecycle_error_deprecated}.
}
}

\examples{
# A deprecated function `foo`:
deprecate_warn("1.0.0", "foo()")

# A deprecated argument `arg`:
deprecate_warn("1.0.0", "foo(arg)")

# A partially deprecated argument `arg`:
deprecate_warn("1.0.0", "foo(arg = 'must be a scalar integer')")

# A deprecated function with a function replacement:
deprecate_warn("1.0.0", "foo()", "bar()")

# A deprecated function with a function replacement from a
# different package:
deprecate_warn("1.0.0", "foo()", "otherpackage::bar()")

# A deprecated function with custom message:
deprecate_warn(
  when = "1.0.0",
  what = "foo()",
  details = "Please use `otherpackage::bar(foo = TRUE)` instead"
)

# A deprecated function with custom bulleted list:
deprecate_warn(
  when = "1.0.0",
  what = "foo()",
  details = c(
    x = "This is dangerous",
    i = "Did you mean `safe_foo()` instead?"
  )
)
}
\seealso{
\code{\link[=lifecycle]{lifecycle()}}
}
