% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictCor.R
\name{predictCor}
\alias{predictCor}
\title{Prediction of the Brownian motion or the autoregressive correlation}
\usage{
predictCor(model, newdata, predtimes)
}
\arguments{
\item{model}{an object inheriting from class \code{hlme}, \code{lcmm}, 
\code{Jointlcmm} or \code{multlcmm} representing a general latent class
mixed model.}

\item{newdata}{data frame containing the data from which predictions are to be computed. 
The data frame should include at least all the covariates listed in model$Xnames2, and
the marker(s) values. Names should match exactly the names 
of the variables in the model.}

\item{predtimes}{numeric vector containing the prediction times}
}
\value{
a matrix containing the predicted correlation in each latent class
}
\description{
The function computes the predicted values of the BM or AR correlation given observed data
provided in input.
}
\examples{
\dontrun{
 m <- hlme(fixed = Y ~ Time, mixture = ~1, random = ~1, subject = "ID",
  ng = 2, cor = BM(Time), data = data_hlme, B = c(0,20,30,-1,5,2,0.1))
 predictCor(m, newdata = data_hlme[1:3, ], predtimes = seq(0, 5, 0.5))
}
}
\author{
Viviane Philipps, Cecile Proust-Lima
}
