% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lvm.R
\name{lvm}
\alias{lvm}
\alias{print.lvm}
\alias{summary.lvm}
\title{Initialize new latent variable model}
\usage{
lvm(x = NULL, ..., latent = NULL, messages = lava.options()$messages)
}
\arguments{
\item{x}{Vector of variable names. Optional but gives control of the
sequence of appearance of the variables. The argument can be given as a
character vector or formula, e.g. \code{~y1+y2} is equivalent to
\code{c("y1","y2")}. Alternatively the argument can be a formula specifying
a linear model.}

\item{\dots}{Additional arguments to be passed to the low level functions}

\item{latent}{(optional) Latent variables}

\item{messages}{Controls what messages are printed (0: none)}
}
\value{
Returns an object of class \code{lvm}.
}
\description{
Function that constructs a new latent variable model object
}
\examples{

m <- lvm() # Empty model
m1 <- lvm(y~x) # Simple linear regression
m2 <- lvm(~y1+y2) # Model with two independent variables (argument)
m3 <- lvm(list(c(y1,y2,y3)~u,u~x+z)) # SEM with three items

}
\seealso{
\code{\link{regression}}, \code{\link{covariance}},
\code{\link{intercept}}, ...
}
\author{
Klaus K. Holst
}
\keyword{models}
\keyword{regression}
