% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_mining.R
\name{cleanText}
\alias{cleanText}
\alias{cleanNames}
\title{Clean text strings automatically}
\usage{
cleanText(
  text,
  spaces = TRUE,
  keep = "",
  lower = TRUE,
  ascii = TRUE,
  title = FALSE
)

cleanNames(df, num = "x", keep = "_", ...)
}
\arguments{
\item{text}{Character Vector}

\item{spaces}{Boolean. Keep spaces? If character input, spaces
will be transformed into passed argument.}

\item{keep}{Character. String (concatenated or as vector) with all characters
that are accepted and should be kept, in addition to alphanumeric.}

\item{lower}{Boolean. Transform all to lower case?}

\item{ascii}{Boolean. Only ASCII characters?}

\item{title}{Boolean. Transform to title format (upper case on first letters).}

\item{df}{data.frame/tibble.}

\item{num}{Add character before only-numeric names.}

\item{...}{Additional parameters passed to \code{cleanText()}.}
}
\value{
Character vector with transformed strings.

data.frame/tibble with transformed column names.
}
\description{
\code{cleanText}: Clean character strings automatically. Options to keep ASCII
characters only, keep certain characters, lower caps, title format, are available.

\code{cleanNames}: Resulting names are unique and consist only of the \code{_}
character, numbers, and ASCII letters. Capitalization preferences can be
specified using the \code{lower} parameter.
}
\details{
Inspired by \code{janitor::clean_names}.
}
\examples{
cleanText("Bernardo Lares 123")
cleanText("Bèrnärdo LáreS 123", lower = FALSE)
cleanText("Bernardo Lare$", spaces = ".", ascii = FALSE)
cleanText("\\\\@®ì÷å   \%ñS  ..-X", spaces = FALSE)
cleanText(c("maría", "€", "núñez_a."), title = TRUE)
cleanText("29_Feb-92()#", keep = c("#", "_"), spaces = FALSE)

# For a data.frame directly:
df <- dft[1:5, 1:6] # Dummy data
colnames(df) <- c("ID.", "34", "x_2", "Num 123", "Nòn-äscì", "  white   Spaces  ")
print(df)
cleanNames(df)
cleanNames(df, lower = FALSE)
}
\seealso{
Other Data Wrangling: 
\code{\link{balance_data}()},
\code{\link{categ_reducer}()},
\code{\link{date_cuts}()},
\code{\link{date_feats}()},
\code{\link{file_name}()},
\code{\link{formatHTML}()},
\code{\link{holidays}()},
\code{\link{impute}()},
\code{\link{left}()},
\code{\link{normalize}()},
\code{\link{num_abbr}()},
\code{\link{ohe_commas}()},
\code{\link{ohse}()},
\code{\link{quants}()},
\code{\link{removenacols}()},
\code{\link{replaceall}()},
\code{\link{replacefactor}()},
\code{\link{textFeats}()},
\code{\link{textTokenizer}()},
\code{\link{vector2text}()},
\code{\link{year_month}()},
\code{\link{zerovar}()}

Other Text Mining: 
\code{\link{ngrams}()},
\code{\link{remove_stopwords}()},
\code{\link{replaceall}()},
\code{\link{sentimentBreakdown}()},
\code{\link{textCloud}()},
\code{\link{textFeats}()},
\code{\link{textTokenizer}()},
\code{\link{topics_rake}()}
}
\concept{Data Wrangling}
\concept{Text Mining}
