% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landpred.R
\name{landpred}
\alias{landpred}
\title{Create a Landpred Object}
\usage{
landpred(formula, data, discrete = FALSE, no.covariates = FALSE)
}
\arguments{
\item{formula}{A formula object with a Surv object on the LHS and covariates on the RHS.}

\item{data}{The data frame.}

\item{discrete}{Logical, whether to use the discrete method (legacy).}
\item{no.covariates}{Logical, whether there are covariates or not.}
}
\value{
A landpred_object.
}
\description{
Parses the formula and data to create a landpred object used for landmark prediction.
Call `?landpred.pacakge` for more information on the legacy API.
}
\examples{
library(landpred)
library(survival)

# Load example data
data(data_example_landpred)

# Define landmark time and prediction window
t0 <- 2
tau <- 8

# Create a landpred object using the formula interface
# The formula specifies: Long-term survival ~ Short-term survival + Covariates
# Note: The short-term event must be a Surv object
obj <- landpred(
  Surv(XL, DL) ~ Surv(XS, DS) + Z,
  data = data_example_landpred,
  discrete = FALSE
)
\donttest{
# 1. Optimize bandwidth (Optional but recommended)
# This uses cross-validation to find the optimal bandwidth for the short-term event
# We use log transformation for the time variable as it's often more appropriate
bw <- optimize_bandwidth(
  landpred_obj = obj,
  t0 = t0,
  tau = tau,
  lower = 0.5,
  upper = 5,
  transform = log
)

print(paste("Optimal bandwidth:", bw))

# 2. Fit the model
# We pass the optimized bandwidth and the transformation used
model <- get_model(
  landpred_obj = obj,
  t0 = t0,
  tau = tau,
  bw = bw,
  transform = log
)

print(model)
summary(model,t_s = 1)

# 3. Predict on new data
# For demonstration, we use the first 10 rows of the original data as "new data"
new_data <- data_example_landpred[1:10, ]

# The predict function expects a data frame with the same column names as used in the formula
probs <- predict(model, newdata = new_data)

print("Predicted probabilities:")
print(probs)
}
}
