% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohen_d_borenstein.R
\name{cohen_d_borenstein}
\alias{cohen_d_borenstein}
\title{Calculate Cohen's d as illustrated by Borenstein et al.
(2009, ISBN: 978-0-470-05724-7)}
\usage{
cohen_d_borenstein(
  sample_1 = NULL,
  sample_2 = NULL,
  data = NULL,
  iv_name = NULL,
  dv_name = NULL,
  direction = "2_minus_1",
  ci_range = 0.95,
  output_type = "all",
  initial_value = 0
)
}
\arguments{
\item{sample_1}{a vector of values in the first of two samples}

\item{sample_2}{a vector of values in the second of two samples}

\item{data}{a data object (a data frame or a data.table)}

\item{iv_name}{name of the independent variable}

\item{dv_name}{name of the dependent variable}

\item{direction}{If \code{direction == "2_minus_1"}, Cohen's d will
reflect the extent to which the mean of IV level 2 is greater than
the mean of IV level 2. If \code{direction == "1_minus_2"}, Cohen's d
will reflect the extent to which the mean of IV level 1 is greater than
the mean of IV level 2. By default, \code{direction == "2_minus_1"}.}

\item{ci_range}{range of the confidence interval for Cohen's d
(default = 0.95)}

\item{output_type}{If \code{output_type == "all"} or
if \code{output_type == "d_var_se_and_ci"}, the output will
be a vector of Cohen's d and its variance, SE, and confidence interval.
If \code{output_type == "d_se_and_ci"}, the output will
be a vector of Cohen's d and its SE and confidence interval.
If \code{output_type == "d_and_ci"}, the output will
be a vector of Cohen's d and its confidence interval.
If \code{output_type == "d"}, the output will be Cohen's d.
If \code{output_type == "ci"}, the output will be a vector
of the confidence interval around Cohen's d.
If \code{output_type == "se"}, the output will be the standard error
of Cohen's d.
By default, \code{output_type == "all"}.}

\item{initial_value}{initial value of the noncentrality parameter for
optimization (default = 0). Adjust this value if confidence
interval results look strange.}
}
\description{
Calculates Cohen's d, its standard error, and confidence interval,
as illustrated in the Borenstein et al. (2009, ISBN: 978-0-470-05724-7).
}
\examples{
\donttest{
cohen_d_borenstein(sample_1 = 1:10, sample_2 = 3:12)
cohen_d_borenstein(
data = mtcars, iv_name = "vs", dv_name = "mpg", ci_range = 0.99)
sample_dt <- data.table::data.table(iris)[Species != "setosa"]
cohen_d_borenstein(
data = sample_dt, iv_name = "Species", dv_name = "Petal.Width",
initial_value = 10)
}
}
