% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_functions.R
\name{do_exclude_split}
\alias{do_exclude_split}
\title{Predicate to Check if Split Should be Excluded}
\usage{
do_exclude_split(exclude_levels, .spl_context)
}
\arguments{
\item{exclude_levels}{(\code{list})\cr A named list where names correspond to split variables
and values are vectors of levels to exclude.}

\item{.spl_context}{(\code{data.frame})\cr gives information about ancestor split states
that is passed by \code{rtables}.}
}
\value{
\code{TRUE} if the current split context matches any of the exclude levels,
\code{FALSE} otherwise.
}
\description{
Predicate to Check if Split Should be Excluded
}
\examples{

do_exclude_split(
  exclude_levels = list(AVISIT = "Baseline"),
  .spl_context = data.frame(
    split = c("AVISIT", "ARM"),
    value = c("Week 4", "Placebo")
  )
)
do_exclude_split(
  exclude_levels = list(AVISIT = "Baseline"),
  .spl_context = data.frame(
    split = c("AVISIT", "ARM"),
    value = c("Baseline", "Placebo")
  )
)
}
