% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jrSiCKLSNMF.R
\name{BuildKNNGraphLaplacians}
\alias{BuildKNNGraphLaplacians}
\title{Build KNN graphs and generate their graph Laplacians}
\usage{
BuildKNNGraphLaplacians(SickleJr, k = 20)
}
\arguments{
\item{SickleJr}{An object of class SickleJr}

\item{k}{Number of KNN neighbors to calculate; by default, is set to 20}
}
\value{
An object of class SickleJr with a list of graph Laplacians in sparse matrix format
added to the \code{graph.laplacian.list} slot
}
\description{
Generate graph Laplacians for graph regularization of
jrSiCKLSNMF from the list of raw count matrices using a KNN graph. Note that this
is only appropriate when the number of features is considerably greater
than the number of cells in all modalities. If this is not the case, please use
\code{\link{BuildSNNGraphLaplacians}} or any other method of graph
construction that does not rely on the Euclidean distance and store the graph Laplacians for
each modality as a list in the \code{graph.laplacian.list} slot.
}
\examples{
SimSickleJrSmall<-BuildKNNGraphLaplacians(SimSickleJrSmall)
}
\references{
\insertRef{Lun2016}{jrSiCKLSNMF}
}
