% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jpinfect_read_confirmed.R
\name{.jpinfect_read_excels}
\alias{.jpinfect_read_excels}
\title{Process Multiple Excel Files}
\usage{
.jpinfect_read_excels(type, directory, ..., skip_size_check = FALSE)
}
\arguments{
\item{type}{A character string specifying the type of data to import. Must be either \code{"sex"} or \code{"place"}.}

\item{directory}{A character string specifying the directory containing Excel files to process.}
}
\value{
A data frame containing combined case reports from all processed files.
}
\description{
This internal function processes multiple Excel files within a directory. The files are processed based on the
specified type (\code{"sex"} or \code{"place"}).
}
\details{
The function identifies files matching the specified type within the directory. It processes each file using
\code{.jpinfect_read_excel} and combines the results.

Supported file patterns:
\describe{
  \item{\code{"sex"}}{Files with names containing \code{"11.xls"} or \code{"Syu_01_1.xls"}.}
  \item{\code{"place"}}{Files with names containing \code{"Syu_02_1.xls"}.}
}
}
\keyword{internal}
