% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R, R/read.fas.R, R/read.nex.R,
%   R/read.phy.R
\name{read}
\alias{read}
\alias{read.fas}
\alias{read.nex}
\alias{read.phy}
\title{Reading Sequence Files}
\usage{
read.fas(x, text)

read.nex(x)

read.phy(x)
}
\arguments{
\item{x}{A character string, giving the file name.}

\item{text}{A character string in FASTA format.}
}
\value{
An matrix (aligned sequences)  or list (unaligned sequences) of class
  \code{DNAbin} or \code{AAbin}.
}
\description{
Read DNA and amino acid sequences from FASTA, PHILIP, and NEXUS 
  formatted files.
}
\examples{
## bark beetle COX1 sequences
data(ips.cox1)
## create temporary file names
format <- c(".fas", ".phy", ".nex")
fn <- sapply(format, tempfile, 
             pattern = "ips", tmpdir = tempdir())
## write sequences files
write.fas(ips.cox1, fn[".fas"])
write.phy(ips.cox1, fn[".phy"])
write.nex(ips.cox1, fn[".nex"])
## read sequence files
fas <- read.fas(fn[".fas"])
phy <- read.phy(fn[".phy"])
nex <- read.nex(fn[".nex"])
## remove sequence files
unlink(fn)
}
\references{
Maddison, D.R., D.L. Swofford, and W.P. Maddison. 1997. NEXUS: an
  extensible file format for systematic information. \emph{Syst. Biol.} 
  \bold{46}: 590-621.
}
\seealso{
\code{\link{mafft}} and \code{\link{prank}} for sequence alignment,
  \code{\link{gblocks}} and \code{\link{aliscore}} for quality check and
  cleaning of sequence alignments, \code{\link[ape]{cbind.DNAbin}} for
  concatenation of sequence alignments.
}
