% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipft.R
\name{ipfPlotEcdf}
\alias{ipfPlotEcdf}
\title{Plots the cumulative distribution function of the estimated error}
\usage{
ipfPlotEcdf(estimation, xlab = "error",
  ylab = "cumulative density of error",
  title = "Empirical cumulative density function")
}
\arguments{
\item{estimation}{an ipfEstimation}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{title}{plot title}
}
\description{
Plots the cumulative distribution function of the estimated error
}
\examples{

    model <- ipfKnn(ipftrain[1:200, 1:168], ipftrain[1:200, 169:170])
    estimation <- ipfEstimate(model, ipftest[1:20, 1:168], ipftest[1:20, 169:170])
    ipfPlotEcdf(estimation)

}
