% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_coefficients}
\alias{plot_coefficients}
\title{Plot coefficients for multiple targets}
\usage{
plot_coefficients(data, targets = NULL, nrow = NULL, ...)
}
\arguments{
\item{data}{Input data.}

\item{targets}{Targets to plot.
Default is `NULL`.}

\item{nrow}{Number of rows for the plot.
Default is `NULL`.}

\item{...}{Other arguments passed to [plot_coefficient].}
}
\value{
A list of ggplot objects
}
\description{
Plot coefficients for multiple targets
}
\examples{
data(example_matrix)
network_table <- inferCSN(
  example_matrix,
  targets = c("g1", "g2", "g3")
)
plot_coefficients(network_table, show_values = FALSE)
plot_coefficients(network_table, targets = "g1")
}
