% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLstring_gene_copies_combine.R
\name{GLstring_gene_copies_combine}
\alias{GLstring_gene_copies_combine}
\title{GLstring_gene_copies_combine}
\usage{
GLstring_gene_copies_combine(.data, columns, sample_column = "sample")
}
\arguments{
\item{.data}{A data frame}

\item{columns}{The names of the columns in the data frame that contain typing
information to be combined}

\item{sample_column}{The name of the column that identifies samples in the
data frame. Default is "sample".}
}
\value{
A data frame with the specified columns combined into a single column
for each locus, in GL string format.
}
\description{
A function for combining two columns of typing from the same
locus into a single column in the appropriate GL string format.
}
\examples{
library(dplyr)
HLA_typing_1 \%>\%
  mutate(across(A1:B2, ~ HLA_prefix_add(.))) \%>\%
  GLstring_gene_copies_combine(c(A1:B2), sample_column = patient)

}
