% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localidades.R
\name{ibge_localities}
\alias{ibge_localities}
\title{Localities for an aggregate}
\usage{
ibge_localities(aggregate, level = "N6", validate = TRUE)
}
\arguments{
\item{aggregate}{Numeric aggregate identifier.}

\item{level}{Geographic level. Use \code{"N1"} (Brazil), \code{"N2"} (region),
\code{"N3"} (state), \code{"N6"} (municipality), \code{"N7"} (metropolitan area), etc.
For multiple levels, use a vector: \code{c("N6", "N7")}.}

\item{validate}{Logical. If \code{TRUE} (default), validates level against
aggregate metadata. Use \code{FALSE} to skip.}
}
\value{
A \link[tibble:tibble]{tibble} with columns:
\code{id}, \code{name}, \code{level_id}, \code{level_name}
}
\description{
Retrieves available localities for an aggregate at one or more geographic
levels. Validates the requested level(s) against the aggregate metadata
before querying.
}
\examples{
\dontrun{
ibge_localities(1437, level = "N1")
ibge_localities(1437, level = c("N6", "N7"))
}

}
