% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_footnote.R
\name{tar_footnote}
\alias{tar_footnote}
\title{Add Footnote to Graph and Save as PNG}
\usage{
tar_footnote(
  graph,
  style,
  string,
  filename = NULL,
  output_dir = tempdir(),
  overwrite = FALSE,
  ask = interactive()
)
}
\arguments{
\item{graph}{A `grViz` graph object.}

\item{style}{A character string specifying the CSS style for the footnote.}

\item{string}{A character string specifying the footnote text.}

\item{filename}{Optional output filename (without extension). Defaults to the
variable name of `graph` if possible.}

\item{output_dir}{Output directory (default: temporary directory).}

\item{overwrite}{Logical; overwrite an existing PNG (default: FALSE).}

\item{ask}{Logical; if TRUE, prompt when file exists (default: interactive()).}
}
\value{
None. The function saves a PNG file in the working directory.
}
\description{
This function takes a `grViz` graph object, adds a footnote with specified style and text,
and saves the graph along with the footnote as a PNG file. The PNG file is named based on the
graph object name.
}
\examples{
\donttest{
if (interactive() && requireNamespace("DiagrammeR", quietly = TRUE)) {
graph <- DiagrammeR::grViz("
digraph {
graph [layout = dot]
node [shape = box]
a [label = 'A']
b [label = 'B']
a -> {b}
}
")

style <- "color: grey; font-family: Arial; text-align: left; font-size: 10px;"
string <- paste(
  "CNCT = Consolidation Chemotherapy,",
  "CRT = Chemoradiotherapy,",
  "CT = Chemotherapy,",
  "INCT = Induction Chemotherapy,",
  "SCRT = Short-course Radiotherapy,",
  "TME = Total Mesorectal Excision,",
  "WW = Watch and Wait,",
  sep = " "
)

tar_footnote(graph, style, string)
}
}
}
