% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mahalanobis.R
\name{Mahalanobis}
\alias{Mahalanobis}
\title{Classical and Robust Mahalanobis Distances}
\usage{
Mahalanobis(
  x,
  center,
  cov,
  method = c("classical", "mcd", "mve"),
  nsamp = "best",
  ...
)
}
\arguments{
\item{x}{a numeric matrix or data frame with, say, \eqn{p} columns}

\item{center}{mean vector of the data; if this and \code{cov} are both supplied,
the function simply calls \code{\link[stats]{mahalanobis}} to
calculate the result}

\item{cov}{covariance matrix (p x p) of the data}

\item{method}{estimation method used for center and covariance, one of:
\code{"classical"} (product-moment),
\code{"mcd"} (minimum covariance determinant), or
\code{"mve"} (minimum volume ellipsoid).}

\item{nsamp}{passed to \code{\link[MASS]{cov.rob}}}

\item{...}{other arguments passed to \code{\link[MASS]{cov.rob}}}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{ a vector of length `nrow(x)` containing the squared distances.
}\if{html}{\out{</div>}}
}
\description{
This function is a convenience wrapper to \code{\link[stats]{mahalanobis}}
offering also the possibility to calculate robust Mahalanobis squared
distances using MCD and MVE estimators of center and covariance (from
\code{\link[MASS]{cov.rob}})
}
\details{
Any missing data in a row of \code{x} causes \code{NA} to be returned for
that row.
}
\examples{

summary(Mahalanobis(iris[, 1:4]))
summary(Mahalanobis(iris[, 1:4], method="mve"))
summary(Mahalanobis(iris[, 1:4], method="mcd"))


}
\seealso{
\code{\link[stats]{mahalanobis}}, \code{\link[MASS]{cov.rob}}

Other robust methods: 
\code{\link{plot.robmlm}()},
\code{\link{robmlm}()}
}
\author{
Michael Friendly
}
\concept{robust methods}
\keyword{multivariate}
