% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wetbulb.R
\name{wetbulb}
\alias{wetbulb}
\title{Wet-bulb temperature}
\usage{
wetbulb(
  p,
  T,
  rh,
  psychrometric = FALSE,
  icebulb = FALSE,
  verbose = TRUE,
  lewis = 0.85
)
}
\arguments{
\item{p}{The total air pressuire in Pa. This can be a single number, a vector, a matrix, or an array.}

\item{T}{The absolute air temperature in Kelvin. This can be a single number, a vector, a matrix, or an array.}

\item{rh}{The relative humidity of the air, with values in the range of 0 to 1, with respect to saturation over liquid water for air temperatures over 273.16 K and with respect to saturation over ice for air temperatures lower than 273.16 K. This can be a single number, a vector, a matrix, or an array.}

\item{psychrometric}{A logical indicating whether to calculate the thermodynamic wet-bulb temperature (if \code{FALSE}) or the psychometric (a.k.a., ventilated or aspirated) wet-bulb temperature (if \code{TRUE}). Default is \code{FALSE}.}

\item{icebulb}{A logical indicating whether to calculate the temperature of an ice-bulb (if \code{TRUE}) or wet-bulb (if \code{FALSE}). Default is \code{FALSE}.}

\item{verbose}{A logical indicating whether or not to print warning messages. Default is \code{TRUE}.}

\item{lewis}{The Lewis number for moist air. Default is \code{0.85}.}
}
\value{
The values of the wet-bulb temperature, in Kelvin, in the same shape as \code{p}, \code{T}, and \code{rh}.
}
\description{
\code{wetbulb} calculates the thermodynamic (or psychrometric) wet-bulb (or ice-bulb) temperature using the Rankine-Kirchhoff approximations.
}
\examples{
wetbulb(1e5,300,0)
wetbulb(1e5,301:310,0)
wetbulb(1e5,301:310,1:10/10)
wetbulb(1:10*1e4,301:310,1:10/10)
}
\references{
Romps, D. M. (2025). Wet-bulb temperature from pressure, relative humidity, and air temperature. In review.
}
\author{
David M. Romps \email{romps@berkeley.edu}
}
