% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plt-alos.R
\name{ts_alos_plt}
\alias{ts_alos_plt}
\title{Plot ALOS - Average Length of Stay}
\usage{
ts_alos_plt(.data, .date_col, .value_col, .by_grouping, .interactive)
}
\arguments{
\item{.data}{The time series data you need to pass}

\item{.date_col}{The date column}

\item{.value_col}{The value column}

\item{.by_grouping}{How you want the data summarized - "sec", "min", "hour",
"day", "week", "month", "quarter" or "year"}

\item{.interactive}{TRUE or FALSE. TRUE returns a \code{plotly} plot and FALSE
returns a static \code{ggplot2} plot}
}
\value{
A timetk time series plot
}
\description{
Plot ALOS - Average Length of Stay
}
\details{
\itemize{
\item Expects a tibble with a date time column and a value column
\item Uses \code{timetk} for underlying sumarization and plot
\item If .by_grouping is missing it will default to "day"
\item A static ggplot2 object is return if the .interactive function is FALSE
otherwise a \code{plotly} plot is returned.
}
}
\examples{
library(healthyR)
library(healthyR.data)
library(timetk)
library(dplyr)
library(purrr)

# Make A Series of Dates ----
data_tbl <- healthyR_data

df_tbl <- data_tbl \%>\%
    filter(ip_op_flag == "I") \%>\%
    select(visit_end_date_time, length_of_stay) \%>\%
    summarise_by_time(
        .date_var = visit_end_date_time
        , .by     = "day"
        , visits  = mean(length_of_stay, na.rm = TRUE)
    ) \%>\%
    filter_by_time(
        .date_var     = visit_end_date_time
        , .start_date = "2012"
        , .end_date   = "2019"
    ) \%>\%
    set_names("Date","Values")

ts_alos_plt(
  .data = df_tbl
  , .date_col = Date
  , .value_col = Values
  , .by = "month"
  , .interactive = FALSE
)

}
\seealso{
Other Plotting Functions: 
\code{\link{diverging_bar_plt}()},
\code{\link{diverging_lollipop_plt}()},
\code{\link{gartner_magic_chart_plt}()},
\code{\link{los_ra_index_plt}()},
\code{\link{ts_median_excess_plt}()},
\code{\link{ts_plt}()},
\code{\link{ts_readmit_rate_plt}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Plotting Functions}
