% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_duration.R
\name{compute_duration}
\alias{compute_duration}
\title{Compute duration between two dates}
\usage{
compute_duration(
  from,
  to,
  lower_brks = NULL,
  unit = c("year", "day", "week", "month"),
  trans = FALSE,
  .transfn = lubridate::ymd,
  verbose = getOption("healthdb.verbose"),
  ...
)
}
\arguments{
\item{from}{A character or Date vector for start dates.}

\item{to}{A character or Date vector for end dates.}

\item{lower_brks}{A numeric vector for lower breaks passing to the base \code{\link[base:cut]{base::cut()}} function to convert the numeric result to a factor. The level labels will be auto generated. For example, the level labels are \code{c("<19", "19-24", "25-34", "35-44", "45-54", "55+")} for \code{lower_brks = c(0, 19, 25, 35, 45, 55)}. Default is NULL (no conversion).}

\item{unit}{A character string specifying the unit of the output. One of "year" (default), "day", "week", or "month".}

\item{trans}{A logical for whether transform both \code{from} and \code{to} with the \code{.transfn} function}

\item{.transfn}{A function for transforming the inputs. Default is \code{\link[lubridate:ymd]{lubridate::ymd()}}.}

\item{verbose}{A logical for whether print summary of the out and warning for missing values. Default is fetching from options. Use \code{options(healthdb.verbose = FALSE)} to suppress once and for all.}

\item{...}{Additional arguments passing to \code{\link[base:cut]{base::cut()}}.}
}
\value{
A numeric or factor vector of the duration.
}
\description{
This function is meant to be for data frame input only and used with \code{\link[dplyr:mutate]{dplyr::mutate()}} to compute age or duration between two character or Date columns. If a vector of breaks is given, the output will be converted to factor with labels generated automatically.
}
\examples{
# toy data
n <- 5
df <- data.frame(id = 1:n,
start_dt = sample(seq(as.Date("1970-01-01"), as.Date("2000-12-31"), by = 1), size = n),
end_dt = sample(seq(as.Date("2001-01-01"), as.Date("2023-12-31"), by = 1), size = n))

# get age group at a cut-off
df \%>\% dplyr::mutate(
 age_grp = compute_duration(start_dt, "2023-01-01", lower_brks = c(0, 19, 25, 35, 45, 55))
)

# compute gaps between two dates in weeks
df \%>\% dplyr::mutate(
 gap_wks = compute_duration(start_dt, end_dt, unit = "week")
)
}
