% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pns.R
\name{pns_sidra_tables}
\alias{pns_sidra_tables}
\title{List PNS SIDRA tables}
\usage{
pns_sidra_tables(theme = NULL, year = NULL)
}
\arguments{
\item{theme}{Character. Filter by theme. NULL returns all themes.
Available themes: "chronic_diseases", "lifestyle", "health_services",
"health_perception", "womens_health", "accidents_violence",
"oral_health", "anthropometry", "health_insurance", "disability",
"elderly", "tobacco", "alcohol", "physical_activity", "nutrition",
"medications", "mental_health", "work_health", "child_health".}

\item{year}{Numeric. Filter tables that contain data for this year.
NULL returns tables for all years.}
}
\value{
A tibble with columns: table_code, table_name, theme,
theme_label, years, territorial_levels.
}
\description{
Returns a catalog of available SIDRA tables for the PNS, organized by
health theme.
}
\examples{
# list all tables
pns_sidra_tables()

# filter by theme
pns_sidra_tables(theme = "chronic_diseases")

# tables with 2013 data
pns_sidra_tables(year = 2013)
}
