% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zigzagMarkovian.R
\name{markovianZigzag}
\alias{markovianZigzag}
\title{Markovian Zigzag Sampler}
\usage{
markovianZigzag(
  nSample,
  burnin = 0,
  mean,
  prec,
  lowerBounds,
  upperBounds,
  init = NULL,
  stepSize = NULL,
  seed = 1,
  diagnosticMode = FALSE,
  nStatusUpdate = 0L
)
}
\arguments{
\item{nSample}{Number of samples after burn-in.}

\item{burnin}{Number of burn-in samples (default = 0).}

\item{mean}{A d-dimensional mean vector.}

\item{prec}{A d-by-d precision matrix of the Gaussian distribution.}

\item{lowerBounds}{A d-dimensional vector specifying the lower bounds.
\code{-Inf} is accepted.}

\item{upperBounds}{A d-dimensional vector specifying the upper bounds.
\code{Inf} is accepted.}

\item{init}{A d-dimensional vector of the initial value. \code{init} must
satisfy all constraints. If \code{init = NULL}, a random initial value will
be used.}

\item{stepSize}{Step size for the Markovian Zigzag sampler. Default value
is the empirically optimal choice: \eqn{\sqrt{2}\lambda^{-1/2}}, where \eqn{\lambda} is the
minimal eigenvalue of the precision matrix.}

\item{seed}{Random seed (default = 1).}

\item{diagnosticMode}{Logical. \code{TRUE} for also returning diagnostic
information such as the step size used.}

\item{nStatusUpdate}{Number of status updates to print during sampling.
If 0 (default), no updates are printed.}
}
\value{
An nSample-by-d matrix of samples. If \code{diagnosticMode} is \code{TRUE},
a list with additional diagnostic information is returned.
}
\description{
Sample from a truncated multivariate normal distribution using the
Markovian Zigzag process, a continuous-time, non-reversible Markov chain
Monte Carlo method based on piecewise deterministic Markov processes (PDMPs).
}
\examples{
set.seed(1)
d <- 5
A <- matrix(runif(d^2)*2-1, ncol=d)
precMat <- t(A) \%*\% A
initial <- rep(1, d)
results <- markovianZigzag(
  nSample = 1000,
  burnin = 1000,
  mean = rep(0, d),
  prec = precMat,
  lowerBounds = rep(0, d),
  upperBounds = rep(Inf, d)
)
}
\references{
Bierkens, J., Roberts, G. O., and Zitt, P.-A. (2019). Ergodicity of the
zigzag process. The Annals of Applied Probability, 29(4): 2266-2301.
}
\seealso{
\code{\link[=getMarkovianZigzagSample]{getMarkovianZigzagSample()}}, \code{\link[=createEngine]{createEngine()}}
}
