% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emi_europe_emep_wear.R
\name{emi_europe_emep_wear}
\alias{emi_europe_emep_wear}
\title{Emissions from road vehicle tyre, brake, and surface wear from the European
Environment Agency (EMEP/EEA) model}
\usage{
emi_europe_emep_wear(
  dist,
  speed,
  pollutant,
  veh_type,
  fleet_composition,
  load = 0.5,
  process = "tyre",
  as_list = TRUE
)
}
\arguments{
\item{dist}{units; Length of each link in 'km'.}

\item{speed}{units; Speed in 'km/h'.}

\item{pollutant}{character; Pollutant, classified in "TSP"(Total Suspended Particles),
"PM10","PM2.5", "PM1.0","PM0.1". Please note that emissions factors for
"PM1.0" and "PM0.1" are  not available for road surface wear process.}

\item{veh_type}{character; Bus type, classified in "Ubus Midi <=15 t",
"Ubus Std 15 - 18 t", "Ubus Artic >18 t", "Coaches Std >18 t", or "Coaches Artic >18 t".}

\item{fleet_composition}{vector; Fleet composition, which is a distribution
of fleet based on frequency. If there is only one, 'fleet_composition' is 1.0.}

\item{load}{numeric; Load ratio, classified in 0.0, 0.5 and 1.0. Default is 0.5.}

\item{process}{character; Emission process sources, classified in "tyre","brake" and/or
"road".}

\item{as_list}{logical; Returns emission factors as a list, instead of data.table format. Default is TRUE.}
}
\value{
List. emission in units 'g' (list or a data.table).
}
\description{
Returns a list or data.table of emissions for urban buses based on Tier 2 of
EMEP/EEA air pollutant emission inventory guidebooks (2019). The function concerns
the emissions of particulate matter (PM), encompassing black carbon (BC) (1),
which arises from distinct sources, namely, road vehicle tire and brake wear
(NFR code 1.A.3.b.vi), and road surface wear (NFR code 1.A.3.b.vii). It is
important to note that PM emissions exhaust from vehicle exhaust are excluded.
The focus is on primary particles, which refer to those that are directly
emitted due to surface wear, rather than those generated from the
resuspension of previously deposited material. See more in @details.
}
\details{
The following equation is employed to evaluate emissions originating from tyre
and brake wear

TE(i) = dist x EF_tsp(j) x mf_s(i) x sc(speed),

where:
\itemize{
\item TE(i)      = total emissions of pollutant i (g),
\item dist       = distance driven by each vehicle (km),
\item EF_tsp(j)  = TSP mass emission factor for vehicles of category j (g/km),
\item mf_s(i)    = mass fraction of TSP that can be attributed to particle size class i,
\item sc(speed)  = correction factor for a mean vehicle travelling at a given speed (-)
}

\emph{Tyre}

In the case of heavy-duty vehicles, the emission factor needs the
incorporation of vehicle size, as determined by the number of axles, and load.
These parameters are introduced into the equation as follows:

EF_tsp_tyre_hdv = 0.5 x N_axle x LCF_tyre x EF_tsp_tyre_pc

where
\itemize{
\item EF_tsp_tyre_hdv  = TSP emission factor for tyre wear from heavy-duty
vehicles (g/km),
\item N_axle           = number of vehicle axles (-),
\item LCF_t            = a load correction factor for tyre wear (-),
\item EF_tsp_tyre_pc   = TSP emission factor for tyre wear from passenger car
vehicles (g/km).
}

and
LCF_tyre = 1.41 + (1.38 x LF),

where:
\itemize{
\item LF = load factor (-), ranging from 0 for an empty bus to 1 for a fully laden one.
}

The function considers the following look-up table for number of vehicle axes:\tabular{ll}{
   vehicle class (j) \tab number of axes \cr
   Ubus Midi <=15 t \tab 2 \cr
   Ubus Std 15 - 18 t \tab 2 \cr
   Ubus Artic >18 t \tab 3 \cr
   Coaches Std <=18 t \tab 2 \cr
   Coaches Artic >18 t \tab 3 \cr
}


The size distribution of tyre wear particles are given by:\tabular{ll}{
   particle size class (i) \tab mass fraction of TSP \cr
   TSP \tab 1.000 \cr
   PM10 \tab 0.600 \cr
   PM2.5 \tab 0.420 \cr
   PM1.0 \tab 0.060 \cr
   PM0.1 \tab 0.048 \cr
}


Finally, the speed correction is:

sc_tyre(speed) = 1.39, when V < 40 km/h;
sc_tyre(speed) = -0.00974 x speed + 1.78, when 40 <= speed <= 90 km/h;
sc_tyre(speed) = 0.902, when speed > 90 km/h.

\emph{Brake}

The heavy-duty vehicle emission factor is derived by modifying the passenger
car emission factor to conform to experimental data obtained from
heavy-duty vehicles.

EF_tsp_brake_hdv = 1.956 x LCF_brake x EF_tsp_brake_pc

where:
\itemize{
\item EF_tsp_brake_hdv  = heavy-duty vehicle emission factor for TSP,
\item LCF_brake         = load correction factor for brake wear,
\item EF_tsp_brake_pc   = passenger car emission factor for TSP,
}

and
LCF_brake = 1 + (0.79 x LF),

where:
\itemize{
\item LF = load factor (-), ranging from 0 for an empty bus to 1 for a fully laden one.
}

The size distribution of brake wear particles are given by:\tabular{ll}{
   particle size class (i) \tab mass fraction of TSP \cr
   TSP \tab 1.000 \cr
   PM10 \tab 0.980 \cr
   PM2.5 \tab 0.390 \cr
   PM1.0 \tab 0.100 \cr
   PM0.1 \tab 0.080 \cr
}


Finally, the speed correction is:

sc_brake(speed) = 1.67, when V < 40 km/h;
sc_brake(speed) = -0.0270 x speed + 2.75, when 40 <= speed <= 95 km/h;
sc_brake(speed) = 0.185, when speed > 95 km/h.

\emph{Road Wear}

Emissions are calculated according to the equation:

TE(i) = dist x EF_tsp_road(j) x mf_road

where:
\itemize{
\item TE          = total emissions of pollutant i (g),
\item dist        = total distance driven by vehicles in category j (km),
\item EF_tsp_road = TSP mass emission factor from road wear for vehicles j (0.0760 g/km),
\item mf_road     = mass fraction of TSP that can be attributed to particle size
class i (-).
}

The following table shows the size distribution of road surface wear particles\tabular{ll}{
   particle size class (i) \tab mass fraction of TSP \cr
   TSP \tab 1.00 \cr
   PM10 \tab 0.50 \cr
   PM2.5 \tab 0.27 \cr
}


\emph{References}

#' EMEP/EEA data and reports can be accessed in the following links:
\itemize{
\item 2019 edition \url{https://www.eea.europa.eu/en/analysis/publications/emep-eea-guidebook-2019/}.
}
}
\examples{
emi_europe_emep_wear(dist = units::set_units(1,"km"),
                     speed =  units::set_units(30,"km/h"),
                     pollutant = c("PM10","TSP","PM2.5"),
                     veh_type = c("Ubus Std 15 - 18 t","Ubus Artic >18 t"),
                     fleet_composition = c(0.5,0.5),
                     load = 0.5,
                     process = c("brake","tyre","road"),
                     as_list = TRUE)
}
\seealso{
Other Emission factor model: 
\code{\link{ef_brazil_cetesb}()},
\code{\link{ef_europe_emep}()},
\code{\link{ef_scaled_euro}()},
\code{\link{ef_usa_emfac}()},
\code{\link{ef_usa_moves}()}
}
\concept{Emission factor model}
