% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_color_rows.R
\name{gt_color_rows}
\alias{gt_color_rows}
\title{Add scaled colors according to numeric values or categories/factors}
\usage{
gt_color_rows(
  gt_object,
  columns,
  palette = "ggsci::red_material",
  direction = 1,
  domain = NULL,
  pal_type = c("discrete", "continuous"),
  ...
)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{columns}{The columns wherein changes to cell data colors should occur.}

\item{palette}{The colours or colour function that values will be mapped to}

\item{direction}{Either \code{1} or \code{-1}. If \code{-1} the palette will be reversed.}

\item{domain}{The possible values that can be mapped.

For \code{col_numeric} and \code{col_bin}, this can be a simple numeric
range (e.g. \code{c(0, 100)}); \code{col_quantile} needs representative
numeric data; and \code{col_factor} needs categorical data.

If \code{NULL}, then whenever the resulting colour function is called, the
\code{x} value will represent the domain. This implies that if the function
is invoked multiple times, the encoding between values and colours may not
be consistent; if consistency is needed, you must provide a non-\code{NULL}
domain.}

\item{pal_type}{A string indicating the palette type (one of \code{c("discrete", "continuous")})}

\item{...}{Additional arguments passed to \code{scales::col_numeric()}}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{gt_color_rows} function takes an existing \code{gt_tbl} object and
applies pre-existing palettes from the \code{{paletteer}} package or custom
palettes defined by the user. This function is a custom wrapper around
\code{gt::data_color()}, and uses some of the boilerplate code. Basic use
is simpler than \code{data_color()}.
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{ library(gt)
 # basic use
 basic_use <- mtcars \%>\%
   head(15) \%>\%
   gt() \%>\%
   gt_color_rows(mpg:disp)
 # change palette to one that paletteer recognizes
 change_pal <- mtcars \%>\%
   head(15) \%>\%
   gt() \%>\%
   gt_color_rows(mpg:disp, palette = "ggsci::blue_material")
 # change palette to raw values
 vector_pal <- mtcars \%>\%
   head(15) \%>\%
   gt() \%>\%
   gt_color_rows(
     mpg:disp, palette = c("white", "green"))
     # could also use palette = c("#ffffff", "##00FF00")

 # use discrete instead of continuous palette
 discrete_pal <- mtcars \%>\%
  head(15) \%>\%
  gt() \%>\%
  gt_color_rows(
  cyl, pal_type = "discrete",
  palette = "ggthemes::colorblind", domain = range(mtcars$cyl)
    )
 # use discrete and manually define range
 range_pal <- mtcars \%>\%
   dplyr::select(gear, mpg:hp) \%>\%
   head(15) \%>\%
   gt() \%>\%
   gt_color_rows(
   gear, pal_type = "discrete", direction = -1,
   palette = "colorblindr::OkabeIto_black", domain = c(3,4,5))
}\if{html}{\out{</div>}}
}

\section{Figures}{

\if{html}{\figure{basic-pal.png}{options: width=100\%}}

\if{html}{\figure{blue-pal.png}{options: width=100\%}}

\if{html}{\figure{custom-pal.png}{options: width=100\%}}

\if{html}{\figure{discrete-pal.png}{options: width=100\%}}
}

\section{Function ID}{

4-2
}

\seealso{
Other Colors: 
\code{\link{gt_color_box}()},
\code{\link{gt_hulk_col_numeric}()}
}
\concept{Colors}
