% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_size_nbinom.R
\name{sample_size_nbinom}
\alias{sample_size_nbinom}
\title{Sample size calculation for negative binomial distribution}
\usage{
sample_size_nbinom(
  lambda1,
  lambda2,
  dispersion,
  power = NULL,
  alpha = 0.025,
  sided = 1,
  ratio = 1,
  rr0 = 1,
  accrual_rate,
  accrual_duration,
  trial_duration,
  dropout_rate = 0,
  max_followup = NULL,
  event_gap = NULL
)
}
\arguments{
\item{lambda1}{Rate in group 1 (control).}

\item{lambda2}{Rate in group 2 (treatment).}

\item{dispersion}{Dispersion parameter \code{k} such that \eqn{\mathrm{Var}(Y) = \mu + k \mu^2}.
Note that this is equivalent to \code{1/size} in R's \code{\link[stats:NegBinomial]{stats::rnbinom()}} parameterization.}

\item{power}{Power of the test (1 - beta). Default is 0.9.}

\item{alpha}{Significance level. Default is 0.025.}

\item{sided}{One-sided or two-sided test. 1 for one-sided, 2 for two-sided. Default is 1.}

\item{ratio}{Allocation ratio n2/n1. Default is 1.}

\item{rr0}{Rate ratio under the null hypothesis (lambda2/lambda1).
Default is 1 (superiority).
For non-inferiority, use a value > 1 (e.g., 1.1).
For super-superiority, use a value < 1 (e.g., 0.8).}

\item{accrual_rate}{Vector of accrual rates (patients per unit time).}

\item{accrual_duration}{Vector of durations for each accrual rate. Must be same length
as \code{accrual_rate}.}

\item{trial_duration}{Total planned duration of the trial. If \code{trial_duration}
is less than the sum of \code{accrual_duration}, accrual is truncated at
\code{trial_duration}.}

\item{dropout_rate}{Dropout rate (hazard rate). Default is 0. Can be a vector of length 2.}

\item{max_followup}{Maximum follow-up time for any patient. Default is NULL (infinite).}

\item{event_gap}{Gap duration after each event during which no new events are counted.
Default is NULL (no gap). If provided, the effective event rate is reduced.}
}
\value{
An object of class \code{sample_size_nbinom_result}, which is a list containing:
\describe{
\item{inputs}{Named list of the original function arguments.}
\item{n1}{Sample size for group 1}
\item{n2}{Sample size for group 2}
\item{n_total}{Total sample size}
\item{alpha}{Significance level}
\item{sided}{One-sided or two-sided test}
\item{power}{Power of the test}
\item{exposure}{Average exposure time used in calculation (calendar time). Vector of length 2.}
\item{exposure_at_risk_n1}{Average at-risk exposure time for group 1 (accounts for event gap)}
\item{exposure_at_risk_n2}{Average at-risk exposure time for group 2 (accounts for event gap)}
\item{events_n1}{Expected number of events in group 1}
\item{events_n2}{Expected number of events in group 2}
\item{total_events}{Total expected number of events}
\item{variance}{Variance of the log rate ratio}
\item{accrual_rate}{Accrual rate used in calculation}
\item{accrual_duration}{Accrual duration used in calculation}
}
}
\description{
Computes the sample size for comparing two treatment groups assuming a negative
binomial distribution for the outcome.
}
\examples{
# Calculate sample size for lambda1 = 0.5, lambda2 = 0.3, dispersion = 0.1
# with fixed recruitment of 10/month for 20 months, 24 month trial duration
x <- sample_size_nbinom(
  lambda1 = 0.5, lambda2 = 0.3, dispersion = 0.1, power = 0.8,
  accrual_rate = 10, accrual_duration = 20, trial_duration = 24
)
class(x)
summary(x)

# With piecewise accrual
# 5 patients/month for 3 months, then 10 patients/month for 3 months
# Trial ends at month 12.
x2 <- sample_size_nbinom(
  lambda1 = 0.5, lambda2 = 0.3, dispersion = 0.1, power = 0.8,
  accrual_rate = c(5, 10), accrual_duration = c(3, 3),
  trial_duration = 12
)
summary(x2)
}
\references{
Zhu, H., & Lakkis, H. (2014).
Sample size calculation for comparing two negative binomial rates.
\emph{Statistics in Medicine},
33(3), 376--387. \doi{10.1002/sim.5947}

Friede, T., & Schmidli, H. (2010).
Blinded sample size reestimation with negative binomial counts in
superiority and non-inferiority trials.
\emph{Methods of Information in Medicine},
49(06), 618--624. \doi{10.3414/ME09-02-0060}

Mütze, T., Glimm, E., Schmidli, H., & Friede, T. (2019).
Group sequential designs for negative binomial outcomes.
\emph{Statistical Methods in Medical Research},
28(8), 2326--2347. \doi{10.1177/0962280218773115}
}
\seealso{
\code{vignette("sample-size-nbinom", package = "gsDesignNB")}
for a detailed explanation of the methodology.
}
