% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complex_layout.R
\name{complex_layout}
\alias{complex_layout}
\title{Complex Layout for a gridify object}
\usage{
complex_layout(
  margin = grid::unit(c(t = 0.1, r = 0.1, b = 0.1, l = 0.1), units = "npc"),
  global_gpar = grid::gpar(),
  background = grid::get.gpar()$fill,
  scales = c("fixed", "free")
)
}
\arguments{
\item{margin}{A unit object specifying the margins around the output. Default is 10\% of the output area on all sides.}

\item{global_gpar}{A gpar object specifying the global graphical parameters.
Must be the result of a call to \code{grid::gpar()}.}

\item{background}{A string specifying the background fill colour.
Default \code{grid::get.gpar()$fill} for a white background.}

\item{scales}{A string, either \code{"free"} or \code{"fixed"}.
By default, \code{"fixed"} ensures that text elements (titles, footers, etc.)
retain a static height, preventing text overlap while maintaining a
structured layout. However, this may result in different height proportions
between the text elements and the output.

The \code{"free"} option makes the row heights proportional,
allowing them to scale dynamically based on the overall output size.
This ensures that the text elements and the output maintain relative proportions.}
}
\value{
A gridifyLayout object.
}
\description{
This function creates a complex layout for a gridify object.
The layout consists of six rows and three columns for headers, titles,
notes and footnotes around the output.
}
\details{
The layout consists of six rows for headers, titles, object (figure or table), notes, and footnotes.
The object is placed in the fourth row.\cr
\itemize{
\item With \code{"free"} scales, the row heights are 5\%, 5\%, 5\%, 70\%, 5\%, and 10\% of
the area, respectively.
\item With \code{"fixed"} scales, the row heights are adjusted by the number of lines for all text elements around the object,
with the remaining area occupied by the object.
Note that reducing the output space will retain the space for all text elements, making the object appear smaller.
}
}
\note{
\strong{The Font Issue Information:}

Changes to the fontfamily may be ignored by some devices, but is supported by
PostScript, PDF, X11, Windows, and Quartz. The fontfamily may be used to specify
one of the Hershey Font families (e.g., HersheySerif, serif), and this specification will be
honoured on all devices.

If you encounter this warning, you can register the fonts using the \code{extrafont} package:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(extrafont)
font_import()
loadfonts(device = 'all')
}\if{html}{\out{</div>}}

If you still see the warning while using RStudio, try changing the graphics backend.

\strong{Negative Dimensions Issues:}

grobs from the grid package and ggplot2 objects (when converted to grobs by gridify)
may appear distorted in the output
if there is insufficient space in the window, caused by negative dimensions.
This should be resolved. However, if this is affecting your layout, please increase your window size or
only use static heights/widths for custom layouts.

The negative dimensions are caused by the way grid handles \code{null} and \code{npc} heights/widths so if some dimensions are
static, then the \code{npc} or \code{null} values may cause unexpected behaviour when the window size is too small.
It was resolved by setting a minimum size of the object in the gridify object to 1 inch for each dimension.

The following example demonstrates this behaviour
Try resizing your window:

\preformatted{
library(grid)
library(ggplot2)
grid.newpage()
object <- ggplot2::ggplotGrob(ggplot(mtcars, aes(mpg, wt)) + geom_line())
grid::grid.draw(
  grid::grobTree(
    grid::grobTree(
      grid::editGrob(
        object,
        vp = grid::viewport(
          # height = grid::unit.pmax(grid::unit(1, "npc"), grid::unit(1, "inch")),
          # width = grid::unit.pmax(grid::unit(1, "npc"), grid::unit(1, "inch"))
        )
      ),
      vp = grid::viewport(
        layout.pos.row = 2,
        layout.pos.col = 1:3
      )
    ),
    vp = grid::viewport(
      layout = grid::grid.layout(
        nrow = 3,
        ncol = 3,
        heights = grid::unit(c(9, 1, 9), c("cm", "null", "cm"))
      )
    )
  )
)
}

\strong{gt Font Size Issue:}

When specifying font sizes, the \code{gt} package interprets values as having the
unit pixels (\code{px}), whilst the \code{grid} package, on which \code{gridify} is built,
assumes points (\code{pt}). As a result, even if you set the font sizes in both
\code{gt} and \code{gridify} (using \code{grid::gpar()}) to the same number, they may
still appear different. To convert point size to pixel size, multiply the point size by \code{96 / 72}.
}
\examples{
complex_layout()

# (to use |> version 4.1.0 of R is required, for lower versions we recommend \%>\% from magrittr)
library(magrittr)

gridify(
  object = ggplot2::ggplot(data = mtcars, ggplot2::aes(x = mpg, y = wt)) +
    ggplot2::geom_line(),
  layout = complex_layout()
) \%>\%
  set_cell("header_left", "Left Header") \%>\%
  set_cell("header_middle", "Middle Header") \%>\%
  set_cell("header_right", "Right Header") \%>\%
  set_cell("title", "Title") \%>\%
  set_cell("subtitle", "Subtitle") \%>\%
  set_cell("note", "Note") \%>\%
  set_cell("footer_left", "Left Footer") \%>\%
  set_cell("footer_middle", "Middle Footer") \%>\%
  set_cell("footer_right", "Right Footer")

gridify(
  object = ggplot2::ggplot(data = mtcars, ggplot2::aes(x = mpg, y = wt)) +
    ggplot2::geom_line(),
  layout = complex_layout(margin = grid::unit(c(t = 0.2, r = 0.2, b = 0.2, l = 0.2), units = "npc"))
) \%>\%
  set_cell("header_left", "Left Header") \%>\%
  set_cell("header_right", "Right Header") \%>\%
  set_cell("title", "Title") \%>\%
  set_cell("note", "Note") \%>\%
  set_cell("footer_left", "Left Footer")

gridify(
  object = gt::gt(head(mtcars)),
  layout = complex_layout(
    margin = grid::unit(c(t = 0.2, r = 0.2, b = 0.2, l = 0.2), units = "npc"),
    global_gpar = grid::gpar(col = "blue", fontsize = 18)
  )
) \%>\%
  set_cell("header_left", "Left Header") \%>\%
  set_cell("header_right", "Right Header") \%>\%
  set_cell("title", "Title") \%>\%
  set_cell("note", "Note") \%>\%
  set_cell("footer_left", "Left Footer")
}
