% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{PoolColumns}
\alias{PoolColumns}
\title{Pool reads across columns}
\usage{
PoolColumns(
  data,
  pooling = GetSummarizeMatrix(data, average = FALSE, no4sU = TRUE)
)
}
\arguments{
\item{data}{grandR object}

\item{pooling}{a pooling matrix (see details)}
}
\value{
a new grandR object
}
\description{
Pool read counts, ntrs, and alpha/beta values across columns defined by a pooling matrix
}
\details{
The pooling matrix must have as many rows as there are columns (i.e., samples or cells) in data,
and as many columns as you want to have columns in the resulting object. The matrix should consist of 0 and 1,
where 1 indicates a column of the original object that should go into a column of the new object. In essence,
to obtain the new count matrix, the old count matrix is matrix-multiplied with the pooling matrix.

The new ntr matrix is computed by componentwise division of the new count and total count matrices derived
as just described. alpha and beta are computed using matrix multiplication, i.e. summing up all alpha and beta values
of all the columns belonging to a pool.
}
\concept{data}
