% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streaming.R
\name{goose_stream}
\alias{goose_stream}
\title{Stream Response from Goose}
\usage{
goose_stream(
  query,
  callback = NULL,
  error_callback = NULL,
  complete_callback = NULL,
  session_id = NULL,
  max_time = getOption("goose.stream_timeout", Inf),
  idle_timeout = getOption("goose.stream_idle_timeout", Inf)
)
}
\arguments{
\item{query}{The query to send to Goose}

\item{callback}{Function to call with each chunk (default: cat)}

\item{error_callback}{Function to call on error}

\item{complete_callback}{Function to call on completion}

\item{session_id}{Optional session ID for context}

\item{max_time}{Numeric, maximum runtime in seconds for the stream (default uses
\code{getOption('goose.stream_timeout', Inf)}). Set to \code{Inf} for no limit.}

\item{idle_timeout}{Numeric, maximum time in seconds without receiving any output
before aborting the stream (default uses \code{getOption('goose.stream_idle_timeout', Inf)}).
Set to \code{Inf} for no limit.}
}
\value{
Invisible NULL (results handled via callbacks)
}
\description{
Execute a query with streaming response handling
}
\examples{
\dontrun{
# Simple streaming with default output
goose_stream("Explain R functions")

# Custom callback for processing chunks
goose_stream("Write a function", callback = function(chunk) {
  message("Received: ", nchar(chunk), " characters")
  cat(chunk)
})
}
}
