% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ai_assistant.R
\name{goose_optimize_plot}
\alias{goose_optimize_plot}
\title{Optimize ggplot2 Code with AI}
\usage{
goose_optimize_plot(
  plot_code,
  goals = c("aesthetics", "clarity", "accessibility"),
  data_sample = NULL
)
}
\arguments{
\item{plot_code}{Character string or expression with ggplot2 code}

\item{goals}{Character vector of optimization goals}

\item{data_sample}{Optional sample of the data being plotted}
}
\value{
List with optimized code and suggestions
}
\description{
Get AI suggestions to improve a ggplot2 visualization.
}
\examples{
\dontrun{
plot_code <- "
ggplot(mtcars, aes(x = wt, y = mpg)) +
  geom_point()
"

optimized <- goose_optimize_plot(plot_code, 
                                 goals = c("aesthetics", "clarity"))
}
}
