% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accuracy.R
\name{xvErrorMeasures.default}
\alias{xvErrorMeasures.default}
\title{Cross-validation errror measures}
\usage{
\method{xvErrorMeasures}{default}(x, krigVar, observed, output = "MSDR1", ...)
}
\arguments{
\item{x}{a vector containing the predicted values}

\item{krigVar}{a vector containing the kriging variances}

\item{observed}{a vector containing the true values}

\item{output}{which output do you want? a vector of one or several of  c("ME","MSE","MSDR","Mahalanobis")}

\item{...}{extra arguments for generic functionality}
}
\value{
If just some of c("ME","MSE","MSDR") are requested, the output is a named
vector with the desired quantities. If only "Mahalanobis" is requested, the output is a vector
of Mahalanobis square errors. If you mix up things and ask for "Mahalanobis" and some of
the quantities mentioned above, the result will be a named list with the requested quantities.
}
\description{
Compute one or more error measures from cross-validation output
}
\details{
"ME" stands for \emph{mean error} (average of the differences between true values and predicted values),
"MSE" stands for \emph{mean square error} (average of the square differences between true values and predicted values),
and "MSDR" for \emph{mean squared deviation ratio} (average of the square between true values and predicted values
each normalized by its kriging variance). These quantities are classically used in evaluating
output results of validation exercises of one single variable.
For multivariate cases, see \code{\link[=xvErrorMeasures.data.frame]{xvErrorMeasures.data.frame()}}.
}
\seealso{
Other accuracy functions: 
\code{\link{accuracy}()},
\code{\link{mean.accuracy}()},
\code{\link{plot.accuracy}()},
\code{\link{precision}()},
\code{\link{validate}()},
\code{\link{xvErrorMeasures}()}
}
\concept{accuracy functions}
