% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gstatCompatibility.R,
%   R/compositionsCompatibility.R, R/variograms.R
\name{as.gmCgram.variogramModelList}
\alias{as.gmCgram.variogramModelList}
\alias{as.gmCgram.variogramModel}
\alias{as.gmCgram.LMCAnisCompo}
\alias{as.gmCgram}
\alias{as.gmCgram.default}
\title{Convert theoretical structural functions to gmCgram format}
\usage{
\method{as.gmCgram}{variogramModelList}(m, ...)

\method{as.gmCgram}{variogramModel}(m, ...)

\method{as.gmCgram}{LMCAnisCompo}(
  m,
  V = attr(m, "contrasts"),
  orignames = rownames(m["sill", 1]$sill),
  ...
)

as.gmCgram(m, ...)

\method{as.gmCgram}{default}(m, ...)
}
\arguments{
\item{m}{model to be converted}

\item{...}{further parameters}

\item{V}{original logratio matrix used in the definition of "LMCAnisCompo"}

\item{orignames}{original variable names of the composition}
}
\value{
the covariance/variogram model, recasted to class \code{gmCgram}.
This is a generic function. Methods exist for objects of class
\code{LMCAnisCompo} (for compositional data) and \code{variogramModelList}
(as provided by package \code{gstat}).
}
\description{
Convert covariance function or variogram models to the format gmCgram
of package gmGeostats
}
\section{Methods (by class)}{
\itemize{
\item \code{variogramModelList}: Convert theoretical structural functions to gmCgram format

\item \code{variogramModel}: Convert theoretical structural functions to gmCgram format

\item \code{LMCAnisCompo}: method for "LMCAnisCompo" variogram model objects

\item \code{default}: Convert theoretical structural functions to gmCgram format
}}

\seealso{
Other gmCgram functions: 
\code{\link{[.gmCgram}()},
\code{\link{[[.gmCgram}()},
\code{\link{as.function.gmCgram}()},
\code{\link{length.gmCgram}()},
\code{\link{ndirections}()},
\code{\link{plot.gmCgram}()},
\code{\link{variogramModelPlot}()}
}
\concept{gmCgram functions}
